<?php //Base Theme SEO - The meta boxes that will be displayed in the posts/pages/custom post types

// exit if file is called directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


// save meta box
function base_theme_seo_save_meta_box( $post_id ) {


	$is_autosave = wp_is_post_autosave( $post_id );
	$is_revision = wp_is_post_revision( $post_id );

	$is_valid_nonce = false;

	if ( isset( $_POST[ 'base_theme_seo_meta_box_nonce' ] ) ) {
		if ( wp_verify_nonce( $_POST[ 'base_theme_seo_meta_box_nonce' ], 'posts-meta-box-display.php' ) ) {
			$is_valid_nonce = true;
		}
	}

	if ( $is_autosave || $is_revision || !$is_valid_nonce ) {
		return;
	}


  $post_custom_meta = get_post_meta($post_id, '_base_theme_seo_post_custom_meta', true);

  if ( array_key_exists( 'base-theme-seo-custom-web-title', $_POST ) ) {
    $post_custom_meta['title'] = trim(sanitize_text_field( $_POST[ 'base-theme-seo-custom-web-title' ] ));
	}

	if ( array_key_exists( 'base-theme-seo-custom-web-description', $_POST ) ) {
		$post_custom_meta['description'] = trim(sanitize_text_field( $_POST[ 'base-theme-seo-custom-web-description' ] ));
	}

  if ( array_key_exists( 'base-theme-seo-custom-facebook-title', $_POST ) ) {
    $post_custom_meta['facebook-title'] = trim(sanitize_text_field( $_POST[ 'base-theme-seo-custom-facebook-title' ] ));
	}

	if ( array_key_exists( 'base-theme-seo-custom-facebook-description', $_POST ) ) {
		$post_custom_meta['facebook-description'] = trim(sanitize_text_field( $_POST[ 'base-theme-seo-custom-facebook-description' ] ));
	}

	if ( array_key_exists( 'base-theme-seo-custom-facebook-image', $_POST ) ) {
		$post_custom_meta['facebook-image'] = trim(sanitize_text_field( $_POST[ 'base-theme-seo-custom-facebook-image' ] ));
	}

  if ( array_key_exists( 'base-theme-seo-custom-twitter-title', $_POST ) ) {
    $post_custom_meta['twitter-title'] = trim(sanitize_text_field( $_POST[ 'base-theme-seo-custom-twitter-title' ] ));
	}

	if ( array_key_exists( 'base-theme-seo-custom-twitter-description', $_POST ) ) {
		$post_custom_meta['twitter-description'] = trim(sanitize_text_field( $_POST[ 'base-theme-seo-custom-twitter-description' ] ));
	}

	if ( array_key_exists( 'base-theme-seo-custom-twitter-image', $_POST ) ) {
		$post_custom_meta['twitter-image'] = trim(sanitize_text_field( $_POST[ 'base-theme-seo-custom-twitter-image' ] ));
	}

  update_post_meta(
    $post_id,                                 // Post ID
    '_base_theme_seo_post_custom_meta',       // Meta key
    $post_custom_meta                         // Meta value
  );

}
add_action( 'save_post', 'base_theme_seo_save_meta_box' );
