<?php //Base Theme SEO - Create the meta data that will be used for the meta tags

// exit if file is called directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

function create_meta_tags($post_id) {
  //https://moz.com/learn/seo/title-tag
  //https://developers.facebook.com/docs/sharing/webmasters
  $char_limit = ['description' => 300,
                 'facebook-description' => 280,
                 'twitter-description' => 200];
  $generated_metas = create_post_generated_meta_desc($post_id, $char_limit);
  //var_dump(func_get_args());

  $post_generated_meta['title'] = get_the_title($post_id) . ' - ' . get_bloginfo('name');
  $post_generated_meta['description'] = $generated_metas['description'];
  $post_generated_meta['facebook-description'] = $generated_metas['facebook-description'];
  $post_generated_meta['twitter-description'] = $generated_metas['twitter-description'];

  update_post_meta($post_id, '_base_theme_seo_post_generated_meta', $post_generated_meta);

  meta_tags_to_serve($post_id);
}

//Call create_meta_tags when you publish a post based on accepted post types
// $options = get_option( 'base_theme_seo_options');
// if ( isset ($options['post_type_slugs']) && ! empty($options['post_type_slugs'])) {
//   foreach ($options['post_type_slugs'] as $post_type) {
//     add_action('publish_' . $post_type , 'create_meta_tags', 99);
//   }
// }

//call create_meta_tags when you enter a post edit page based on accepted post types
add_action( 'init', 'base_theme_seo_run_on_edit_post' );
function base_theme_seo_run_on_edit_post() {
    global $pagenow;

    $options = get_option( 'base_theme_seo_options', base_theme_seo_options_default() );
    $post_id = isset($_GET['post']) && ! empty($_GET['post']) ? (int) $_GET['post'] : -1;
    $accepted_post_types = $options['post_type_slugs'];
    $current_post_type = get_post_type($post_id);

    if ( 'post.php' != $pagenow || ! isset( $_GET['post'] ) || 'edit' != $_GET['action'] || false === array_search( $current_post_type , $accepted_post_types ) ) {
        return;
    }

    create_meta_tags($post_id);
}

function create_post_generated_meta_desc($post_id, $char_limit) {
  $options = get_option( 'base_theme_seo_options');

  $generated_description = '';

  foreach ($options['main_call_order'] as $call_order ) {
    if ($call_order == 'the_field') {
      $generated_description.= generate_the_field_desc($post_id);
    } else if ($call_order == 'the_sub_field') {
      $generated_description .= generate_the_sub_field_desc($post_id, 1);
      //echo 'the_sub_field';
    } else if ($call_order == 'the_content') {
      $generated_description .= generate_the_content_desc($post_id);
    } else {
      //echo 'nothing';
    }
  }

	$generated_description = sanitize_text_field(strip_shortcodes($generated_description));
  $generated_description = str_replace('"', "", strip_tags($generated_description));
  $generated_description = preg_replace('/\s+/', ' ', trim($generated_description));
  $returned['description'] = trim(substr($generated_description, 0, $char_limit['description']));
  $returned['facebook-description'] = trim(substr($generated_description, 0, $char_limit['facebook-description']));
  $returned['twitter-description'] = trim(substr($generated_description, 0, $char_limit['twitter-description']));

  return $returned;
}

function generate_the_field_desc ($post_id) {
  $options = get_option( 'base_theme_seo_options', base_theme_seo_options_default() );
  $fields_and_subfields =  $options['field_and_subfield_names'];

  if ( ! isset($fields_and_subfields) || empty($fields_and_subfields) ) {
    return;
  }

  $generated_field_desc = '';


  for ($j=0; $j < count($fields_and_subfields); $j++) {
    if ( isset($fields_and_subfields[$j]) && ! empty($fields_and_subfields[$j])) {
      $generated_field_desc .= trim(get_field($fields_and_subfields[$j], $post_id)) . ' ';
    }
  }
  return $generated_field_desc;
}

function generate_the_sub_field_desc ($post_id, $recursive) {

  $options = get_option( 'base_theme_seo_options', base_theme_seo_options_default() );
  $flexible_content_and_repeater_names = $options['flexible_content_and_repeater_names'];
  $fields_and_subfields =  $options['field_and_subfield_names'];

  if ( ! isset($flexible_content_and_repeater_names) || empty($flexible_content_and_repeater_names) || ! isset($fields_and_subfields) || empty($fields_and_subfields) ) {
    return;
  }

  $generated_sub_field_desc = '';

  for ($i=0; $i < (int) count($flexible_content_and_repeater_names); $i++) {
    if (function_exists('get_sub_field') && function_exists('get_field')) :
      if( have_rows($flexible_content_and_repeater_names[$i], $post_id) ):
        while ( have_rows($flexible_content_and_repeater_names[$i], $post_id) ) : the_row();
          for ($j=0; $j < count($fields_and_subfields); $j++) {
            if ( isset($fields_and_subfields[$j]) && ! empty($fields_and_subfields[$j])) {
              $generated_sub_field_desc .= trim(get_sub_field($fields_and_subfields[$j])) . ' ';
            }
          }


					for ($k=0; $k < (int) count($flexible_content_and_repeater_names); $k++) {
						if (have_rows($flexible_content_and_repeater_names[$k])) {
							while (have_rows($flexible_content_and_repeater_names[$k])) {
								the_row();
								for ($j=0; $j < count($fields_and_subfields); $j++) {
			            if ( isset($fields_and_subfields[$j]) && ! empty($fields_and_subfields[$j])) {
			              $generated_sub_field_desc .= trim(get_sub_field($fields_and_subfields[$j])) . ' ';
			            }
			          }
							}
						}
					}

        endwhile; // sections loop
      endif; // sections exits
    endif; //gravity forms exists
  }
  return $generated_sub_field_desc;
}

function generate_the_content_desc($post_id) {
  $content_post = get_post($post_id);
  $content = $content_post->post_content;
  $content = trim(sanitize_text_field($content));
  if (strtolower($content) != "content") {
    return $content . ' ';
  } else {
    return '';
  }
}


function meta_tags_to_serve($post_id) {
  $post_custom_meta = get_post_meta($post_id, '_base_theme_seo_post_custom_meta', true);

  $web_custom_title = isset($post_custom_meta['title']) ? $post_custom_meta['title'] : '';
	$web_custom_description = isset($post_custom_meta['description']) ? $post_custom_meta['description'] : '';

  $facebook_custom_title = isset($post_custom_meta['facebook-title']) ? $post_custom_meta['facebook-title'] : '';
	$facebook_custom_description = isset($post_custom_meta['facebook-description']) ? $post_custom_meta['facebook-description'] : '';
	$facebook_custom_image = isset($post_custom_meta['facebook-image']) ? $post_custom_meta['facebook-image'] : '';

  $twitter_custom_title = isset($post_custom_meta['twitter-title']) ? $post_custom_meta['twitter-title'] : '';
	$twitter_custom_description = isset($post_custom_meta['twitter-description']) ? $post_custom_meta['twitter-description'] : '';
	$twitter_custom_image = isset($post_custom_meta['twitter-image']) ? $post_custom_meta['twitter-image'] : '';

  $post_generated_meta = get_post_meta($post_id, '_base_theme_seo_post_generated_meta', true);

  $web_generated_title = isset($post_generated_meta['title']) ? $post_generated_meta['title'] : '';
  $web_generated_description = isset($post_generated_meta['description']) ? $post_generated_meta['description'] : '';

  $facebook_generated_description = isset($post_generated_meta['facebook-description']) ? $post_generated_meta['facebook-description'] : '';

  $twitter_generated_description = isset($post_generated_meta['twitter-description']) ? $post_generated_meta['twitter-description'] : '';

  $meta_web_description = "";
  $meta_image_url = get_the_post_thumbnail_url($post_id);
  //echo $meta_image_url;

  $meta_facebook_title = "";
  $meta_facebook_description = "";
  $meta_facebook_image_url = "";

  $meta_twitter_title = "";
  $meta_twitter_description = "";
  $meta_twitter_image_url = "";


  if ( ! empty($web_custom_description) ) {
    $meta_web_description = $web_custom_description;
  } else if ( ! empty($web_generated_description) ) {
    $meta_web_description = $web_generated_description;
  } else {
    $meta_web_description = '';
  }


  if ( ! empty($facebook_custom_title) ) {
    $meta_facebook_title = $facebook_custom_title;
  } else if (! empty($web_custom_title)) {
    $meta_facebook_title = $web_custom_title;
  }  else if ( ! empty($web_generated_title) ) {
    $meta_facebook_title = $web_generated_title;
  } else {
    $meta_facebook_title = '';
  }

  if ( ! empty($facebook_custom_description) ) {
    $meta_facebook_description = $facebook_custom_description;
  } else if (! empty($web_custom_description)) {
    $meta_facebook_description = $web_custom_description;
  }  else if ( ! empty($facebook_generated_description) ) {
    $meta_facebook_description = $facebook_generated_description;
  } else {
    $meta_facebook_description = '';
  }

	if ( ! empty($facebook_custom_image) ) {
    $meta_facebook_image = $facebook_custom_image;
  } else if ( ! empty($meta_image_url) ) {
    $meta_facebook_image = $meta_image_url;
  } else {
    $meta_facebook_image = '';
  }


  if ( ! empty($twitter_custom_title) ) {
    $meta_twitter_title = $twitter_custom_title;
  } else if (! empty($web_custom_title)) {
    $meta_twitter_title = $web_custom_title;
  }  else if ( ! empty($web_generated_title) ) {
    $meta_twitter_title = $web_generated_title;
  } else {
    $meta_twitter_title = '';
  }

  if ( ! empty($twitter_custom_description) ) {
    $meta_twitter_description = $twitter_custom_description;
  } else if (! empty($web_custom_description)) {
    $meta_twitter_description = $web_custom_description;
  }  else if ( ! empty($twitter_generated_description) ) {
    $meta_twitter_description = $twitter_generated_description;
  } else {
    $meta_twitter_description = '';
  }

	if ( ! empty($twitter_custom_image) ) {
    $meta_twitter_image = $twitter_custom_image;
  } else if ( ! empty($meta_image_url) ) {
    $meta_twitter_image = $meta_image_url;
  } else {
    $meta_twitter_image = '';
  }


  $final_meta['desciption'] = $meta_web_description;
  $final_meta['facebook-title'] = $meta_facebook_title;
  $final_meta['facebook-description']= $meta_facebook_description;
  $final_meta['facebook-image']= $meta_facebook_image;
  $final_meta['twitter-title'] = $meta_twitter_title;
  $final_meta['twitter-description']= $meta_twitter_description;
  $final_meta['twitter-image']= $meta_twitter_image;
  update_post_meta($post_id, '_base_theme_seo_post_final_meta', $final_meta );
}
