<?php // Base Theme SEO - Settings Callbacks



// disable direct file access
if ( ! defined( 'ABSPATH' ) ) {

	exit;

}

// default plugin options
function base_theme_seo_options_default() {

	return array(
		'post_type_slugs'	=> ['page', 'post'],

		'main_call_order'	=> ['the_field', 'the_sub_field', 'the_content'],

		'flexible_content_and_repeater_names'	=> ['sections', 'sidebar'],

		'field_and_subfield_names' => ['wysiwyg', 'wysiwyg_content', 'h2', 'h3', 'h4', 'h5', 'p', 'text', 'paragraph', 'subtitle'],
	);

}



// callback: login section
function base_theme_seo_callback_main_settings() {

	echo '<p>Order does matter for all of the fields below, so make sure you put the most important ones at the top. Each element must be seperated by a new line</p>';

}


// callback: text field
function base_theme_seo_callback_field_text( $args ) {

	$options = get_option( 'base_theme_seo_options', base_theme_seo_options_default() );

	$id    = isset( $args['id'] )    ? $args['id']    : '';
	$label = isset( $args['label'] ) ? $args['label'] : '';

	$value = isset( $options[$id] ) ? sanitize_text_field( $options[$id] ) : '';

	echo '<input id="base_theme_seo_options_'. $id .'" name="base_theme_seo_options['. $id .']" type="text" size="40" value="'. $value .'"><br />';
	echo '<label for="base_theme_seo_options_'. $id .'">'. $label .'</label>';

}



// callback: radio field
function base_theme_seo_callback_field_radio( $args ) {

	$options = get_option( 'base_theme_seo_options', base_theme_seo_options_default() );

	$id    = isset( $args['id'] )    ? $args['id']    : '';
	$label = isset( $args['label'] ) ? $args['label'] : '';

	$selected_option = isset( $options[$id] ) ? sanitize_text_field( $options[$id] ) : '';

	$radio_options = array(

		'enable'  => 'Enable custom styles',
		'disable' => 'Disable custom styles'

	);

	foreach ( $radio_options as $value => $label ) {

		$checked = checked( $selected_option === $value, true, false );

		echo '<label><input name="base_theme_seo_options['. $id .']" type="radio" value="'. $value .'"'. $checked .'> ';
		echo '<span>'. $label .'</span></label><br />';

	}

}



// callback: textarea field list
function base_theme_seo_callback_field_textarea_list( $args ) {



	$options = get_option( 'base_theme_seo_options', base_theme_seo_options_default() );

	$id    = isset( $args['id'] )    ? $args['id']    : '';
	$label = isset( $args['label'] ) ? $args['label'] : '';
	$rows = isset( $args['rows'] ) ? $args['rows'] : '6';

	$allowed_tags = wp_kses_allowed_html( 'post' );

	$value = isset( $options[$id] ) ? wp_kses( ( $options[$id] ), $allowed_tags ) : '';
	$valueTemp = implode(PHP_EOL, $value);
	if ( isset($valueTemp) && ! empty($valueTemp) ) {
		$value = $valueTemp;
	} else {
		$value = '';
	}
	
	echo '<textarea id="base_theme_seo_options_'. $id .'" name="base_theme_seo_options['. $id .']" rows="' . $rows .  '" cols="50">'. $value .'</textarea><br />';
	echo '<label for="base_theme_seo_options_'. $id .'">'. $label .'</label>';

}

// callback: textarea field
function base_theme_seo_callback_field_textarea( $args ) {



	$options = get_option( 'base_theme_seo_options', base_theme_seo_options_default() );

	$id    = isset( $args['id'] )    ? $args['id']    : '';
	$label = isset( $args['label'] ) ? $args['label'] : '';
	$rows = isset( $args['rows'] ) ? $args['rows'] : '6';

	$allowed_tags = wp_kses_allowed_html( 'post' );

	$value = isset( $options[$id] ) ? wp_kses( ( $options[$id] ), $allowed_tags ) : '';

	echo '<textarea id="base_theme_seo_options_'. $id .'" name="base_theme_seo_options['. $id .']" rows="' . $rows .  '" cols="50">'. $value .'</textarea><br />';
	echo '<label for="base_theme_seo_options_'. $id .'">'. $label .'</label>';

}



// callback: checkbox field
function base_theme_seo_callback_field_checkbox( $args ) {

	$options = get_option( 'base_theme_seo_options', base_theme_seo_options_default() );

	$id    = isset( $args['id'] )    ? $args['id']    : '';
	$label = isset( $args['label'] ) ? $args['label'] : '';

	$checked = isset( $options[$id] ) ? checked( $options[$id], 1, false ) : '';

	echo '<input id="base_theme_seo_options_'. $id .'" name="base_theme_seo_options['. $id .']" type="checkbox" value="1"'. $checked .'> ';
	echo '<label for="base_theme_seo_options_'. $id .'">'. $label .'</label>';

}



// callback: select field
function base_theme_seo_callback_field_select( $args ) {

	$options = get_option( 'base_theme_seo_options', base_theme_seo_options_default() );

	$id    = isset( $args['id'] )    ? $args['id']    : '';
	$label = isset( $args['label'] ) ? $args['label'] : '';

	$selected_option = isset( $options[$id] ) ? sanitize_text_field( $options[$id] ) : '';

	$select_options = array(

		'default'   => 'Default',
		'light'     => 'Light',
		'blue'      => 'Blue',
		'coffee'    => 'Coffee',
		'ectoplasm' => 'Ectoplasm',
		'midnight'  => 'Midnight',
		'ocean'     => 'Ocean',
		'sunrise'   => 'Sunrise',

	);

	echo '<select id="base_theme_seo_options_'. $id .'" name="base_theme_seo_options['. $id .']">';

	foreach ( $select_options as $value => $option ) {

		$selected = selected( $selected_option === $value, true, false );

		echo '<option value="'. $value .'"'. $selected .'>'. $option .'</option>';

	}

	echo '</select> <label for="base_theme_seo_options_'. $id .'">'. $label .'</label>';

}
