<?php // callback: validate options

// exit if file is called directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

function base_theme_seo_callback_validate_options( $input ) {

  //var_dump($input);

  // Post Type Slugs
	if ( isset( $input['post_type_slugs'] ) && !is_array( $input['post_type_slugs'] ) ) {
    $input['post_type_slugs'] = base_theme_seo_clean_up_textarea_list($input['post_type_slugs']);
	}

  //Main Call Order
	if ( isset( $input['main_call_order'] ) && !is_array( $input['main_call_order'] ) ) {
    $input['main_call_order'] = base_theme_seo_clean_up_textarea_list($input['main_call_order']);
	}

  //Flexible Content and Repeater Names
	if ( isset( $input['flexible_content_and_repeater_names'] ) && !is_array( $input['flexible_content_and_repeater_names'] ) ) {
    $input['flexible_content_and_repeater_names'] = base_theme_seo_clean_up_textarea_list($input['flexible_content_and_repeater_names']);
	}

  //Field and Subfield Names
	if ( isset( $input['field_and_subfield_names'] ) && !is_array( $input['field_and_subfield_names'] ) ) {
    $input['field_and_subfield_names'] = base_theme_seo_clean_up_textarea_list($input['field_and_subfield_names']);
	}
	
	return $input;

}

function base_theme_seo_clean_up_textarea_list($input) {
  $textarea_list = explode(PHP_EOL, $input);
  $textarea_list_length = count($textarea_list);
  for ($i = 0; $i < $textarea_list_length; $i++) {
    $textarea_list[$i] = sanitize_text_field(trim($textarea_list[$i],"\x2C\t\n\r\0\x0B"));
    if (empty($textarea_list[$i])) {
      array_splice($textarea_list, $i, 1);
      $i--;
      $textarea_list_length--;
    }
  }
  return $textarea_list;
}

/*
page
post

the_field
the_sub_field
the_content

sections
sidebar

wysiwyg
h2
h3
h4
h5
p
text
headphones
paragraph
*/
