<?php
console_log(array('sections' => get_field('sections')));
$count_sections = is_array(get_field('sections')) ? count(get_field('sections')) : 0;

function flex_options() {
    $options = array(
        'id'           => get_sub_field('section_id'),
        'classes'      => get_sub_field('klasses'), // this starts with "k" on purpose
        'disabled'     => get_sub_field('disable_mode'),
        'styles'       => get_sub_field('styles'),
        'attributes'   => get_sub_field('attributes'),
        'bg_image'     => get_sub_field('background_image') ? 'background-image:url("'.get_sub_field('background_image').'"); ' : '',
        'bg_color'     => get_sub_field('background_color') ? 'background-color:'.get_sub_field('background_color').'; ' : '',
        'text_color'   => get_sub_field('text_color') ? 'color:'.get_sub_field('text_color').'; ' : '',
    );
    return $options;
}

function block_scripts() {
    $bs_options = array(
        'block_header'    => get_sub_field('block_header') ? get_sub_field('block_header') : '',
        'block_footer'    => get_sub_field('block_footer') ? get_sub_field('block_footer') : ''
    );

    return $bs_options;
}

function flex_open_wrap($options) {
  $markup = '<div id="'.$options['id'].'" class="'.$options['classes'].'" style="'.$options['bg_image'].$options['bg_color'].$options['text_color'].$options['styles'].'" '.$options['attributes'].'>';
  return $markup;
}

function content_block() {
    $options = flex_options();
    $block_scripts = block_scripts();
    $content = do_shortcode(get_sub_field('content'));
    $block = $block_scripts['block_header'] . $content . $block_scripts['block_footer'];
    return $block;
}

function get_used_page_templates() {
    $posts_and_pages = new WP_Query(array('post_type' => array('post', 'page'), 'numberposts' => -1));
    $results = $posts_and_pages->posts; $count_results = count($results);
    $templates = array();
    for($r = 0; $r < $count_results; $r++) {
        $template = get_post_meta($results[$r]->ID, '_wp_page_template', true);
        array_push($templates, $template);
    }
    return $templates;
}

function get_page_templates($return = 'full') {
    $page_templates = wp_get_theme()->get_page_templates();
    switch($return) {
        case 'full': return $page_templates; break;
        case 'keys': return array_keys($page_templates); break;
        case 'values': return array_values($page_templates); break;
    }
}

// console_log(array(
//   'get_page_templates' => get_page_templates('keys')
// ));



if(have_rows('sections')): echo '<div id="flex-builder-wrap">';
    while(have_rows('sections')): the_row();

        $section = flex_options();
        $section['layout'] = get_row_layout();
        $section['index'] = get_row_index();

        if(!$section['disabled']):
            $section_wrap = '<div id="flex-section-'.$section['index'].'" class="flex-section container-fluid px-0">';
            $flex_wrap = flex_open_wrap($section);
            $close_div = '</div>';
            $fc_engine = array(
                'code_block'        => function() {echo content_block();},
                'post_block'        => function() {get_template_part('/flex/post-block');},
                'swiper_block'      => function() {get_template_part('/flex/swiper-block');},
                'template_block'    => function() {get_template_part(get_sub_field('template_block_part'));}
            );

            if($section['layout'] && in_array($section['layout'], array_keys($fc_engine)) ):
              if(!get_sub_field('disable_mode')):
                    echo $section_wrap . $flex_wrap;
                        call_user_func($fc_engine[$section['layout']]);
                    echo $close_div . $close_div;
              endif;
            endif;

        endif;

    endwhile; echo '</div>';
endif;
