<?php
$swiper_id = get_sub_field('swiper_id');
$swiper_type = get_sub_field('swiper_type');
$swiper_class = get_sub_field('swiper_class') ? get_sub_field('swiper_class') : 'swiper-block';
$swiper_pagination = get_sub_field('swiper_pagination') ? '<div class="swiper-pagination"></div>' : '';
$swiper_arrows = get_sub_field('swiper_arrows') ? '<div class="swiper-button-next"></div><div class="swiper-button-prev"></div>' : '';
$slides_per_view = get_sub_field('slides_per_view') ? get_sub_field('slides_per_view') : 1;
$space_between = get_sub_field('space_between') ? get_sub_field('space_between') : 0;
$loop_mode = get_sub_field('loop') > 0 ? 'true' : 'false';
$autoplay = get_sub_field('autoplay') ? 'true' : 'false';
$delay = get_sub_field('autoplay') ? get_sub_field('delay') : '2500';
$disable_on_interaction = get_sub_field('disable_on_interaction') ? 'true' : 'false';
$autoplay_config = get_sub_field('autoplay') ? 'autoplay: {"delay": '.$delay.', "disableOnInteraction": '.$disable_on_interaction.'}, ' : '';
$breakpoints = get_sub_field('breakpoints') ? json_decode(json_encode(get_sub_field('breakpoints')), 1) : '{}';

if(get_sub_field($swiper_type)) {

  echo '<div id="'.$swiper_id.'" class="swiper-container '.$swiper_class.'">'.
          '<div class="swiper-wrapper" style="margin-bottom:3rem;">';

  switch($swiper_type) {
    case 'swiper_custom':
      while(has_sub_field($swiper_type)) {
        echo '<div class="swiper-slide" style="margin-right:'.$space_between.'px">';
          echo do_shortcode(get_sub_field('slide_content'));
          //get_template_part('/loops/loop-'.$swiper_type);
        echo '</div>';
      }
      break;
    case 'swiper_query':
      $swiper_query = get_sub_field('swiper_query');
      //console_log(array('swiper_query' => $swiper_query));
      set_query_var('swiper_mode', true);
      set_query_var('swiper_query', $swiper_query);
      get_template_part('/flex/post-block');
      break;
    case 'swiper_gallery':
      while(has_sub_field($swiper_type)) {
        if(get_sub_field('image_type') == 'image') {
            echo '<div id="'.get_sub_field('id').'" class="swiper-slide" style="margin-right:'.$space_between.'px; '.get_sub_field('styles').'" '.get_sub_field('attributes').'>';
              $open_new_tab = get_sub_field('open_new_tab') ? 'target="_blank"' : '';
              echo get_sub_field('has_url') ? '<a href="'.get_sub_field('url').'" '.$open_new_tab.'>' : '';
                echo '<img class="'.get_sub_field('classes').'" src="'.get_sub_field('image').'" alt="" />';
              echo get_sub_field('has_url') ? '</a>' : '';
            echo '</div>';
        } elseif(get_sub_field('image_type') == 'banner') {
          $open_new_tab = get_sub_field('open_new_tab') ? 'target="_blank"' : '';

          echo '<div
                  id="'.get_sub_field('id').'"
                  class="swiper-slide '.get_sub_field('image_classes').'"
                  style="'.get_sub_field('image_styles').' background:linear-gradient(rgba(0,0,0,'.(get_sub_field('overlay_opacity') ? get_sub_field('overlay_opacity') : 0).'),rgba(0,0,0,'.(get_sub_field('overlay_opacity') ? get_sub_field('overlay_opacity') : 0).')), url('.get_sub_field('image').'); '.get_sub_field('styles').'" '.get_sub_field('attributes').'>';
          echo get_sub_field('has_url') ? '<a href="'.get_sub_field('url').'" '.$open_new_tab.'>' : '';
          echo get_sub_field('content');
          echo get_sub_field('has_url') ? '</a>' : '';
          echo '</div>';

        }
      }
      break;
  }


  echo '</div>'.$swiper_pagination.$swiper_arrows.'</div>';

}

echo '<script>'.
      '(function() {"use-strict"; '.
        'var current_swiper_'.get_row_index().' = new Swiper("#'.$swiper_id.'", {'.
          ($swiper_pagination ? 'pagination: {el: ".swiper-pagination", clickable: true}, ' : '').
          ($swiper_arrows ? 'navigation: {nextEl: ".swiper-button-next", prevEl: ".swiper-button-prev"}, ' : '').
          'slidesPerView: '.$slides_per_view.', '.
          'spaceBetween: '.$space_between.', '.
          'loop: '.$loop_mode.', '.
          $autoplay_config.
          'breakpoints: '.$breakpoints.''.
        '});'.
      '})();'.
     '</script>';
