<?php
/**
 * The template for displaying the footer.
 *
 * Contains the closing of the #content div and all content after
 *
 * @package understrap
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

?>

<?php get_template_part( 'sidebar-templates/sidebar', 'footerfull' ); ?>

<?php get_template_part( '/templates/footer-wrapper'); ?>

</div><!-- #page we need this extra closing tag here -->

<?php wp_footer(); ?>

<div id="back-to-top" class="back-to-top">
	<div class="container-fluid px-3 pt-4 text-center">
		<a href="#page" class="b2t-btn inline-block text-white" style="animation:pulse 1s infinite;"><i class="fa fa-arrow-up" style="font-size:3rem;"></i></a>
	</div>
	<div class="container-fluid px-3 text-center">
		<p class="ab-white-text font-2 text-white" style="animation:pulse 1s infinite;">Back to Top</p>
	</div>
</div>

</body>

<script>
<?php echo get_field('footer_js', 'option'); ?>
</script>

<script>

	jQuery(document).ready(function($) {
		// jQuery Smooth Scrolling Back to Top on Click
	  function scrollToTopJS(anchorClass, time) {
	      $( anchorClass ).click(function( event ) {
	          event.preventDefault();
	          $("html, body").animate({ scrollTop: $($(this).attr("href")).offset().top }, time);
	      });
	  }
		// Init Scroll To Top JS
		scrollToTopJS('.b2t-btn', 300);
	});

</script>

<?php if(!is_mobile()): ?>
		<script>

				// Hoverable Navigation Menu
				jQuery(document).ready(function($) {
					$('#main-menu li').hover(
						function(e) {
							$(this).addClass('show');
							$(this).find('a.dropdown-toggle.nav-link').attr('aria-expanded', 'true');
							$(this).find('ul.dropdown-menu').addClass('show');
						},
						function(e) {
							$(this).removeClass('show');
							$(this).find('a.dropdown-toggle.nav-link').attr('aria-expanded', 'false');
							$(this).find('ul.dropdown-menu').removeClass('show');
						}
					);
				});


				document.querySelectorAll('#main-menu li.menu-item.dropdown').forEach(elem => {
					var anchor = elem.querySelector('a[data-toggle="dropdown"]');
					console.log({elem: elem, anchor: anchor});
					var anchor_text = anchor.innerHTML;
					anchor.addEventListener('click', function(e) {
						e.preventDefault();
						let link = this.getAttribute('href');
						window.location.href = link;
					})
					var dropdown = elem.querySelector('ul');
					// console.log({dropdown: dropdown});
					var child_li = dropdown.querySelector('li');
					var child_anchor = child_li.querySelector('a');
					var child_anchor_text = child_anchor.innerHTML;
					var child_link = child_anchor.getAttribute('href');
					// console.log({
					// 	anchor: anchor,
					// 	dropdown: dropdown,
					// 	chiild_li: child_li,
					// 	child_anchor: child_anchor,
					// 	child_link: child_link
					// });
					if(anchor_text == child_anchor_text && anchor_text != "INVESTORS") {
						anchor.setAttribute('href', child_link);
						child_anchor.style.display = "none";
					}
				});

		</script>
<?php endif; ?>

</html>
