<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

include(locate_template('/inc/base-scripts.php'));

add_filter( 'rest_authentication_errors', function( $result ) {
    if ( ! empty( $result ) ) {
        return $result;
    }
    if ( count(explode("wp-json/wp/v2/users", $_SERVER['REQUEST_URI'])) > 1 ) {
        return new WP_Error( 'rest_not_logged_in', 'Big no-no, don\'t lookup our users.', array( 'status' => 401 ) );
    }
    return $result;
});

function understrap_remove_scripts() {
    wp_dequeue_style( 'understrap-styles' );
    wp_deregister_style( 'understrap-styles' );

    wp_dequeue_script( 'understrap-scripts' );
    wp_deregister_script( 'understrap-scripts' );

    // Removes the parent themes stylesheet and scripts from inc/enqueue.php
}
add_action( 'wp_enqueue_scripts', 'understrap_remove_scripts', 20 );

add_action( 'wp_enqueue_scripts', 'theme_enqueue_styles' );

function theme_enqueue_styles() {
    // Get the theme data
	  $the_theme = wp_get_theme();

    // Enqueue Styles
    wp_enqueue_style( 'child-understrap-styles', get_stylesheet_directory_uri() . '/css/child-theme.min.css', array(), $the_theme->get( 'Version' ) );
    //wp_enqueue_style( '', get_stylesheet_directory_uri() . '/css/base/', array(), $the_theme->get( 'Version' ) );
    wp_enqueue_style( 'animate-css', get_stylesheet_directory_uri() . '/css/base/animate.min.css', array(), $the_theme->get( 'Version' ) );
    //wp_enqueue_style( 'select2-css', get_stylesheet_directory_uri() . '/css/base/select2.min.css', array(), $the_theme->get( 'Version' ) );
		if(is_front_page()):
    	wp_enqueue_style( 'swiper-css', get_stylesheet_directory_uri() . '/css/base/swiper.min.css', array(), $the_theme->get( 'Version' ) );
		endif;
    wp_enqueue_style( 'base-css', get_stylesheet_directory_uri() . '/css/base/base.css', array(), $the_theme->get( 'Version' ) );

    // Enqueue Scripts
    wp_enqueue_script( 'jquery');
	  //wp_enqueue_script( 'popper-scripts', get_template_directory_uri() . '/js/popper.min.js', array(), false);
    wp_enqueue_script( 'child-understrap-scripts', get_stylesheet_directory_uri() . '/js/child-theme.min.js', array(), $the_theme->get( 'Version' ), true );
    //wp_enqueue_script( '', get_stylesheet_directory_uri() . '/js/base/', array(), true);
    //wp_enqueue_script( 'gravitystyles-css', get_stylesheet_directory_uri() . '/js/base/gravitystyles.css', array('jquery'), true);
    wp_enqueue_script( 'viewport-checker-js', get_stylesheet_directory_uri() . '/js/base/viewportchecker.min.js', array('jquery'), true);
    wp_enqueue_script( 'viewoprt-animate-js', get_stylesheet_directory_uri() . '/js/base/viewport-animate.js', array('jquery'), true);
		if(is_front_page()):
    	wp_enqueue_script( 'swiper-js', get_stylesheet_directory_uri() . '/js/base/swiper.min.js', array(), true);
		endif;
    //wp_enqueue_script( 'select2-js', get_stylesheet_directory_uri() . '/js/base/select2.min.js', array('jquery'), true);
    //wp_enqueue_script( 'masonry-js', get_stylesheet_directory_uri() . '/js/base/masonry.min.js', array('jquery'), true);
    //wp_enqueue_script( 'list-js', get_stylesheet_directory_uri() . '/js/base/list.min.js', array('jquery'), true);
    //wp_enqueue_script( 'base-js', get_stylesheet_directory_uri() . '/js/base/base.js', array('jquery'), true);

    if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
        wp_enqueue_script( 'comment-reply' );
    }
}

// Overrides load_fonts function in inc/enqueue.php of parent theme, add custom font here
function load_fonts() {
  // Google Fonts
  wp_enqueue_style( 'understrap-google-fonts', 'https://fonts.googleapis.com/css?family=Roboto:300,400', false );
  wp_enqueue_style( 'understrap-google-icons', 'https://fonts.googleapis.com/icon?family=Material+Icons', false );

}


/*~~~~~ Begin Base Theme PHP Scripts ~~~~~*/
