<?php

//ACF THEME Options Pages (only run if function exists)
if( function_exists('acf_add_options_page') ) {
	// Define Option Pages
	$acfo_base = array(
		'page_title' => 'Base Options',
		'menu_title' => 'Base Options',
		'menu_slug' => 'base-options',
		'capability' => 'edit_posts',
		'redirect' => false
	);

	// Define Sub Option Pages
	$acfo_sub_custom_scripts = array(
		'page_title' => 'Custom Scripts',
		'menu_title' => 'Custom Scripts',
		'menu_slug' => 'custom-scripts',
		'parent_slug' => 'base-options',
		'capability' => 'edit_posts',
		'redirect' => false,
	);

	// Define Sub Option Pages
	$acfo_sub_ajax_loaders = array(
		'page_title' => 'AJAX Loaders',
		'menu_title' => 'AJAX Loaders',
		'menu_slug' => 'ajax-loaders',
		'parent_slug' => 'base-options',
		'capability' => 'edit_posts',
		'redirect' => false,
	);

	$acfo_sub_theme_styles = array(
		'page_title' => 'Theme Styles',
		'menu_title' => 'Theme Styles',
		'menu_slug' => 'theme-styles',
		'parent_slug' => 'base-options',
		'capability' => 'edit_posts',
		'redirect' => false,
	);

	// Enqueue Option and Sub Option Pages
	acf_add_options_page($acfo_base);
	acf_add_options_sub_page($acfo_sub_custom_scripts);
	acf_add_options_sub_page($acfo_sub_ajax_loaders);
	acf_add_options_sub_page($acfo_sub_theme_styles);
}


/// LOGIN/PW PROTECTED ITEMS
// add_action("login_head", "abtheme_login_head");
// add_action("password_protected_login_head", "abtheme_login_head" );
// function abtheme_login_head() {
// 	 if(function_exists('get_field')) { $logo = get_field('logo','option'); }
//    if ($logo){$logo_url=$logo[url];}
//    else{$logo_url= get_bloginfo('template_url')."/inc/img/logo.png";}
//    // Echo Stylesheet or Enqueue Stylesheet Directory Template Here
// }

// Convert Text Block into Attribute Friendly String
function attr_friendly_str($string) {
  echo strtolower(str_replace(' ', '-', $string));
}

// Set a Word/Character Limit to any block of text
function trim_text($str, $chars, $end = '...') {
    if (strlen($str) <= $chars) return $str;
    $new = substr($str, 0, $chars + 1);
    return substr($new, 0, strrpos($new, ' ')) . $end;
}

// Enable Gravity Forms Field Label Invisibility
add_filter( 'gform_enable_field_label_visibility_settings', '__return_true' );

function youtube_video($config = array()) {
  $youtube = "https://www.youtube.com/embed/";
  isset($config->width) ? $width = $config->width : $width = 560;
  isset($config->height) ? $height = $config->height : $height = 315;
  isset($config->youtube_id) ? $youtube_id = $config->youtube_id : $youtube_id = "6G59zsjM2UI";
  echo '<iframe width="'.$width.'" height="'.$height.'" src="'.$youtube.$youtube_id.'" frameborder="0" allowfullscreen></iframe>';
}

// Vimeo Player
function vimeo_player($vimeo_id, $height, $width) {
  $vimeo = "https://player.vimeo.com/video/";
  isset($vimeo_id) ? $vimeo_id = $vimeo_id : $vimeo_id = 194900488;
  isset($width) ? $width = $width : $width = 640;
  isset($height) ? $height = $height : $height = 360;
  echo '<iframe src="'.$vimeo.$vimeo_id.'" width="'.$width.'" height="'.$height.'" frameborder="0" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>';
}

function vimeo_player_2($video_id) {
      $vimeo = "https://player.vimeo.com/video/";
      isset($video_id) ? $video_id : $video_id = 194900488;
      echo '<iframe src="'.$vimeo.$video_id.'" class="vimeo-player-2" frameborder="0" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>';
    }

// Background Image with Linear Gradient Overlay
function bg_overlay($url, $opacity_top, $opacity_bottom) {
	echo 'background:linear-gradient(rgba(0, 0, 0, '.$opacity_top.'), rgba(0, 0, 0, '.$opacity_bottom.')), url(\''.$url.'\')';
}

function fyuse_loop_player($fyuse_id, $max_height = false) {
    	isset($fyuse_id) ? $fyuse_id : $fyuse_id = 'kbizsvyzqy';
    	$max_height === true ? $set_max_height = $max_height : '';
    	echo '<div id="fyu_'.$fyuse_id.'" class="fyu_container fyu_vertical"></div>'.
           '<script src="https://fyu.se/embed?v=2.0"></script>'.
           '<script>FYU.add("'.$fyuse_id.'", "fyu_'.$fyuse_id.'",{\'autoplay\':1,\'nologo\':1});</script>';
    }

function vimeo_json_parser($id) {
      if($id) {
        $vimeo_json = file_get_contents('https://vimeo.com/api/oembed.json?url=https://player.vimeo.com/video/'.$id);
        //console_log(json_decode($vimeo_json));
        return $vimeo_json;
      }
}

function vimeo_json_thumbnail_url($id) {
	  ob_start();
	  $vimeo_obj = $vimeo_json = file_get_contents('https://vimeo.com/api/oembed.json?url=https://vimeo.com/'.$id);
	  //console_log(json_decode($vimeo_obj));
	  $vimeo_decode = json_decode($vimeo_obj, true);
	  ob_get_clean();
	  console_log($vimeo_decode);
	  if(isset($vimeo_decode['thumbnail_url'])){
	    return $vimeo_decode['thumbnail_url'];
	  }
}

function vimeo_thumbnail_url($id = '', $thumbType = 'medium') {
// reference: https://gist.github.com/anjan011/3b6d13a9f7a8642ecc4c
      $id = trim( $id );
      if ( $id == '' ) {
          return FALSE;
      }
      $apiData = unserialize( file_get_contents( "https://vimeo.com/api/v2/video/".$id.".php" ) );
      if ( is_array( $apiData ) && count( $apiData ) > 0 ) {
          $videoInfo = $apiData[ 0 ];
          switch ( $thumbType ) {
              case 'small':
                  return $videoInfo[ 'thumbnail_small' ];
                  break;
              case 'large':
                  return $videoInfo[ 'thumbnail_large' ];
                  break;
              case 'medium':
                  return $videoInfo[ 'thumbnail_medium' ];
              default:
                  break;
          }
      }
      return FALSE;
}


function vimeo_thumbnail($id = '', $thumbType = 'medium') {
  	echo '<img src="'.vimeo_thumbnail_url($id, $thumbType).'" alt="vimeo-thumbnail-'.$id.'" />';
}


// ACF Frontend Form
function acf_frontend_form($post_type = 'post', $form_type = 'new_post') {
		$new_acf_form = array(
			'id'                 => 'new_post',
			'post_id'	           => 'new_post',
			'post_title'         => true,
			'post_content'       => false,
			'new_post'	         => array(
				'post_type'		     => $post_type,
				'post_status'      => 'publish'
			),
			'form'               => true,
			// 'return'             => '%post_url%',
			'html_before_fields' => '',
			'html_after_fields'  => '',
			'submit_value'       => 'Submit',
			'updated_message'    => 'Saved!'
		);
		acf_form($new_acf_form);
}

// Modal Function
function ab_modal($template_path = true, $template, $modal_id) {
		isset($modal_id) ? $modal_id : $modal_id = 'ab-modal';
		if(isset($template)) {
			echo '<style>'.
							'.ab-modal {position:fixed; top:0; right:0; bottom:0; left:0; display:none; background:linear-gradient(rgba(0, 0, 0, 0.4), rgba(0, 0, 0, 0.4)); z-index:1050; overflow:hidden; -webkit-overflow-scrolling:touch; outline:0; transition:all 0.3s linear;} .display-block {display:block !important;}'.
							'.close-ab-modal {float:right; width:35px; height:35px; border-radius:50%; background:#2199e8;text-align:center; display:table; margin:5px 5px 0 0; cursor:pointer;}'.
							'.close-ab-modal a {display:table-cell; vertical-align:middle; font-size:24px; color:#fff; text-decoration:none;}'.
						'</style>';
			echo '<div id="'.$modal_id.'" class="ab-modal animated fadeOut">';
				echo '<div class="centerize ctz-xs padder-xxl">';
						  echo '<div class="close-ab-modal"><a class="modal-trigger" data-modal="#'.$modal_id.'">x</a></div>';
								if($template_path = true) {get_template_part($template);}
								else if($template_path = false) {echo $template;}
				echo '</div>';
			echo '</div>';
		} else {
			echo 'Error: either your template_path boolean is not set, or you have not declared your template argument.';
		}
}


// AB Nav Menu Function
function ab_nav_menu($menu_name, $nav_id) {
	wp_nav_menu(array(
   'menu'              => $menu_name,
   'theme_location'    => $menu_name,
   'depth'             => 2,
   'container'         => 'div',
   'container_class'   => 'collapse navbar-collapse',
   'container_id'      => $nav_id,
   'menu_class'        => 'nav navbar-nav navbar-right',
   'fallback_cb'       => 'wp_bootstrap_navwalker::fallback',
   'walker'            => new WP_Bootstrap_Navwalker()
 ));
}

function register_abx_nav_menus() {
	register_nav_menus(array(
		'footer-menu' => __('Footer Menu'),
		'custom-menu'	 => __('Custom Menu')
	));
}
add_action('init', 'register_abx_nav_menus');

// Image Placeholder
function imgph($width, $height, $classes = '', $styles = '') {
	if(isset($width) && isset($height)) {
		echo '<img src="https://via.placeholder.com/'.$width.'x'.$height.'" alt="placeholder" class="'.$classes.'" style="'.$styles.'" />';
	}
}

// Image Placeholder URL
function imgph_url($width, $height) {
		return 'https://via.placeholder.com/'.$width.'x'.$height;
}

// Console.log() PHP Variables into the JavaScript Console
function console_log($obj) {
  $jobj = json_encode($obj);
  echo '<script>console.log('.$jobj.');</script>';
}

/*** Get Child Template ***/
function get_child_template_part($template_path = '') {
	include(get_stylesheet_directory() . $template_path . '.php');
}

/*** Get Child Template ***/
function get_child_template_part_ext($template_path = '', $template_args) {
		isset($template_args) ? $template_args = $template_args : $template_args = 0;
		if($template_args !== 0) {
		    $include_path = get_stylesheet_directory() . $template_path . '.php';
		    include($include_path);
		} else {
		  	echo 'Error, check your syntax for get_child_template_part() function.';
		}
}



// Gravity Forms Pre Submission Webhook
//add_action('gform_pre_submission_#', 'gform_#_pre_submission_handler');
//function gform_#_pre_submission_handler() {
	// Append Current User ID to
	//$_POST['input_#'] = wp_get_current_user()->ID;
//}

//*** MANAGE_{CUSTOM_POST_TYPE}_POSTS_COLUMNS: SET_CUSTOM_EDIT_{CUSTOM_POST_TYPE}_COLUMNS ***//
// Add the custom columns to the book post type:
add_filter( 'manage_faq_posts_columns', 'set_custom_edit_faq_columns' );
function set_custom_edit_faq_columns($columns) {
		unset( $columns['author'] );
		$columns['faq_author'] = __( 'Author', 'Author' );
		$columns['faq_type'] = __( 'FAQ Type', 'FAQ Type' );

		return $columns;
}

// Add data to custom column for custom post type FAQ
add_action( 'manage_faq_posts_custom_column' , 'custom_faq_column', 10, 2 );
function custom_faq_column( $column, $post_id ) {
		switch ( $column ) {
		    case 'faq_author' :
		        $author_name = get_post_field('post_author', $post_id);
		        echo get_the_author_meta('display_name', $author_name);
		        break;
		    case 'faq_type' :
		        $faq_type = get_the_terms($post_id, 'faq_type');
		        if($faq_type !== false) {
		          $count_faq_type = count($faq_type);
		          for($q = 0; $q < $count_faq_type; $q++) {
		            echo '<span class="button">'.$faq_type[$q]->name.'</span>';
		          }
		        }
		     		break;
		}
}


// Add EXPORT ALL POSTS BUTTON to EDIT.PHP Admin View
add_action( 'restrict_manage_posts', 'add_export_button' );
function add_export_button() {
	$screen = get_current_screen();
	// console_log($screen);
	if (isset($screen->parent_file)) {
	// && ('edit.php' == $screen->parent_file)
		 echo '<input type="submit" name="export_all_posts" id="export_all_posts" class="button button-primary" value="Export All Posts">'.
					'<script type="text/javascript">'.
							'jQuery(function($) {'.
									'$(\'#export_all_posts\').insertAfter(\'#post-query-submit\');'.
							'});'.
					'</script>';
	}
}

// Hook EXPORT ALL POSTS ACTION into BUTTON
add_action( 'init', 'func_export_all_posts' );
function func_export_all_posts() {
	// if export_all_posts is set in HTTP $_GET request
	if(isset($_GET['export_all_posts'])) {
		// Set get_posts() query args
		$current_post_type = get_current_screen()['post_type'];
  	$arg = array('post_type' => $current_post_type, 'posts_per_page' => -1,);
		// Define Global $post object
    global $post;
		// Get Posts with $arg variable
    $arr_post = get_posts($arg);
		// If ARR_Post Query sets true
    if ($arr_post) {
			// Set PHP Header Params
	    header('Content-type: text/csv');
	    header('Content-Disposition: attachment; filename="wp.csv"');
	    header('Pragma: no-cache');
	    header('Expires: 0');
			// Retrieve PHP Output
			$file = fopen('php://output', 'w');
			// Set New File
			//array('Post Title', 'URL')
			fputcsv($file, array('Post Title', 'URL'));
 			// Append Each Post Object as Row into new CSV
			foreach ($arr_post as $post) {
	      setup_postdata($post);
	      fputcsv($file, array(get_the_title(), get_the_permalink()));
      }
			// foreach ($arr_post as $post) {
	    //   setup_postdata($post);
			// 	$set_post = get_post($post->ID);
			// 	$set_row = new Array();
			// 	for($p = 0; $p <= count($set_post); $p++) {
			// 		$pval = $set_post[$p];
			// 		array_push($set_row, $pval);
			// 	}
	    //   fputcsv($file, $set_row);
      // }
			// Exit Sequence
			exit();
    } // end if()
  } // end if()
} // end func_export_all_posts()


function abx_search_form($config = array(
	'form_id' => 'search-form',
	'method' => 'GET',
	'post_type' => 'post',
	'action' => '/',
	'classes' => '',
	'placeholder' => 'Search...'
)) {
	echo  '<form id="'.$form_id.'" action="'.$action.'" method="'.$method.'"class="searchform '.$classes.'">'.
					'<input type="text" name="s" value="' . get_search_query() . '" placeholder="' . $placeholder . '" />'.
					'<input type="hidden" name="post_type" value="' . $post_type . '" />'.
					'<input type="submit" value="Search" />'.
				'</form>';
}

// Pagination Bar
function pagination_bar($max_num_pages = false) {
    if ($max_num_pages > 1){
        $current_page = max(1, get_query_var('paged'));

        echo paginate_links(array(
            'base' => get_pagenum_link(1) . '%_%',
            'format' => '/page/%#%',
            'current' => $current_page,
            'total' => $max_num_pages,
        ));
    }
}

function get_the_paginator($max_num_pages = false) {
    if($max_num_pages) {
        if ($max_num_pages > 1){
            $current_page = max(1, get_query_var('paged'));

            return paginate_links(array(
                'base' => get_pagenum_link(1) . '%_%',
                'format' => count($_GET) > 1 ? '&page=%#%' : '?page=%#%',
                'current' => $current_page,
                'total' => $max_num_pages,
            ));
        }
    } else {return false;}
}

function wp_query_template($custom_query, $template_part, $sub_part = null) {
  ob_start();
  if($custom_query->have_posts()): while($custom_query->have_posts()): $custom_query->the_post();
    get_template_part($template_part, $sub_part);
  endwhile; endif; wp_reset_query();
  $content = ob_get_contents();
  ob_end_clean();
  return $content;
  exit;
}

// FUNCTION : WP_Query_Template()
function get_wp_query_template($the_query, $template_part, $sub_part = null, $pre, $post, $before, $after) {
  ob_start();
  if($the_query->have_posts()):
		echo $pre;
			while($the_query->have_posts()): $the_query->the_post();
				echo $before;
		    get_template_part($template_part, $sub_part);
				echo $after;
	  	endwhile;
		echo $post;
	endif; wp_reset_query();
  $content = ob_get_contents();
  ob_end_clean();
  return $content;
  exit;
}

function wpquery_shortcode($atts = array()) {
	$sc = shortcode_atts(array(
		'template' => '',
		'sub_part' => null,
		'post_type' => 'post',
		'posts_per_page' => 10,
		'pagination' => false,
		'page'	=> get_query_var('page') ? get_query_var('page') : 1,
		'orderby'	=> 'date',
		'order'		=> 'DESC',
		'meta_query' => false,
		'before' => '',
		'after' => '',
		'pre' => '',
		'post' => ''
	), $atts);
	$args = array('post_type' => $sc['post_type'], 'posts_per_page' => $sc['posts_per_page'], 'orderby' => $sc['orderby'], 'order' => $sc['order']);
	if($sc['pagination']) {$args['page'] = $sc['page'];}
	if($sc['template']) {
		$new_wpquery = new WP_Query($args);
		echo get_wp_query_template($new_wpquery, $sc['template'], $sc['sub_part'], $sc['pre'], $sc['post'], $sc['before'], $sc['after']);
	} else {
		echo 'no template.';
		return false;
	}

}
add_shortcode('wpquery', 'wpquery_shortcode');

function buffered_code($atts, $content) {
	ob_start();
	echo $content;
	return ob_get_clean();
	exit;
}
add_shortcode('buffcode', 'buffered_code');


// Custom Admin Title for ACF Flex Content Engine
// Reference: https://serversideguy.com/2017/03/28/how-can-i-create-custom-titles-for-advanced-custom-fields-flexible-content-blocks/
if ( ! function_exists( 'my_admin_title' ) ) {
  function my_admin_title($title, $field, $layout, $i) {
    if($value = get_sub_field('admin_title')) {
      return $title . " - " . $value;
    } else {
      foreach($layout['sub_fields'] as $sub) {
        if($sub['name'] == 'admin_title') {
          $key = $sub['key'];
          if(array_key_exists($i, $field['value']) && $value = $field['value'][$i][$key])
            return $title . " - " . $value;
        }
      }
    }
    return $title;
  }
  }
add_filter('acf/fields/flexible_content/layout_title', 'my_admin_title', 10, 4);


// Register Custom User Roles
// -- WEB_MANAGER
add_role('web_manager', 'Web Manager', array(
	'edit_pages'						=> true,
	'edit_posts'						=> true,
	'edit_theme_options'		=> true,
	'edit_others_pages'			=> true,
	'edit_others_posts'			=> true,
	'edit_published_pages'	=> true,
	'edit_published_posts'	=> true,
	'manage_categories'			=> true,
	'manage_links'					=> true,
	'manage_options'				=> true,
	'publish_pages'					=> true,
	'publish_posts'					=> true,
	'read'									=> true,
	'upload_files'					=> true,
));

// Check if is Mobile 
function is_mobile() {
		$useragent=$_SERVER['HTTP_USER_AGENT'];
		if(preg_match('/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|ipad|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows (ce|phone)|xda|xiino/i',$useragent)||preg_match('/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i',substr($useragent,0,4))) {
			return true;
		} else {
			return false;
		}
}

// WP_LOADED: Fire before the WC_Form_Handler::add_to_cart_action callback.
// add_action( 'wp_loaded', 'woocommerce_maybe_add_multiple_products_to_cart', 15 );
// function woocommerce_maybe_add_multiple_products_to_cart( $url = false ) {
//     // Make sure WC is installed, and add-to-cart qauery arg exists, and contains at least one comma.
//     if ( ! class_exists( 'WC_Form_Handler' ) || empty( $_REQUEST['add-to-cart'] ) || false === strpos( $_REQUEST['add-to-cart'], ',' ) ) {
//         return;
//     }
//
//     // Remove WooCommerce's hook, as it's useless (doesn't handle multiple products).
//     remove_action( 'wp_loaded', array( 'WC_Form_Handler', 'add_to_cart_action' ), 20 );
//
//     $product_ids = explode( ',', $_REQUEST['add-to-cart'] );
//     $count       = count( $product_ids );
//     $number      = 0;
//
//     foreach ( $product_ids as $id_and_quantity ) {
//
//         // Check for quantities defined in curie notation (<product_id>:<product_quantity>)
//         // https://dsgnwrks.pro/snippets/woocommerce-allow-adding-multiple-products-to-the-cart-via-the-add-to-cart-query-string/#comment-12236
//         $id_and_quantity = explode( ':', $id_and_quantity );
//
//         $product_id = absint($id_and_quantity[0]);
//
//         $_REQUEST['quantity'] = ! empty( $id_and_quantity[1] ) ? absint( $id_and_quantity[1] ) : 1;
// 				++$number;
//         // if ( ++$number === $count ) {
//         //     // Ok, final item, let's send it back to woocommerce's add_to_cart_action method for handling.
//         //     $_REQUEST['add-to-cart'] = $product_id;
//         //     return WC_Form_Handler::add_to_cart_action( $url );
//         // }
//
// 	        //$product_id        = apply_filters( 'woocommerce_add_to_cart_product_id', absint( $product_id ) );
// 	        $was_added_to_cart = false;
// 	        $adding_to_cart    = wc_get_product( $product_id );
//
// 	        if ( ! $adding_to_cart ) {
// 	            continue;
// 	        }
//
// 	        $add_to_cart_handler = apply_filters( 'woocommerce_add_to_cart_handler', $adding_to_cart->get_type(), $adding_to_cart );
//
// 	        // Variable product handling
// 	        if ( 'variable' === $add_to_cart_handler ) {
// 	            woo_hack_invoke_private_method( 'WC_Form_Handler', 'add_to_cart_handler_variable', $product_id );
//
// 	        // Grouped Products
// 	        } elseif ( 'grouped' === $add_to_cart_handler ) {
// 	            woo_hack_invoke_private_method( 'WC_Form_Handler', 'add_to_cart_handler_grouped', $product_id );
//
// 	        // Custom Handler
// 	        } elseif ( has_action( 'woocommerce_add_to_cart_handler_' . $add_to_cart_handler ) ){
// 	            do_action( 'woocommerce_add_to_cart_handler_' . $add_to_cart_handler, $url );
//
// 	        // Simple Products
// 	        } else {
// 	            woo_hack_invoke_private_method( 'WC_Form_Handler', 'add_to_cart_handler_simple', $product_id );
// 	        }
//     }
// }
//
// function woo_hack_invoke_private_method( $class_name, $methodName ) {
//     if ( version_compare( phpversion(), '5.3', '<' ) ) {
//         throw new Exception( 'PHP version does not support ReflectionClass::setAccessible()', __LINE__ );
//     }
//
//     $args = func_get_args();
//     unset( $args[0], $args[1] );
//     $reflection = new ReflectionClass( $class_name );
//     $method = $reflection->getMethod( $methodName );
//     $method->setAccessible( true );
//
//     $args = array_merge( array( $class_name ), $args );
//     return call_user_func_array( array( $method, 'invoke' ), $args );
// }
