// Begin App.JS for Dynamic List 1.0
jQuery(document).ready(function($) {

  var pgTopOptions = {name: 'pgTopOptions', paginationClass: 'exlib-pg-top'};
  var pgBotOptions = {name: 'pgBotOptions', paginationClass: 'exlib-pg-bot'};
  //var exLibFuzzyOptions = {searchClass: 'exlib-fuzzy-search', multiSearch: true, threshold: 0.4, distance: 100, location: 0};
  // List Options for Exercise Library

  var current_url = new URL(window.location.href);

  var search_mode = current_url.searchParams.get("search_mode");
  console.log({search_mode: search_mode});
  if(search_mode !== null && search_mode === "search-only") {
    var dynamicValueNames = ['exl-exercise-name'];
  } else if(search_mode !== null && search_mode === "category-only") {
    var dynamicValueNames = ['exl-exercise-name', 'exl-muscle-group', 'exl-muscle-groups-secondary', 'exl-position', 'exl-movement', 'exl-equipment', 'exl-application', 'exl-accessories', 'exl-resistance-profile']
  } else {
    var dynamicValueNames = ['exl-exercise-name', 'exl-muscle-group', 'exl-muscle-groups-secondary', 'exl-position', 'exl-movement', 'exl-equipment', 'exl-application', 'exl-accessories', 'exl-resistance-profile'];
  }
  //var dynamicValueNames = ['exl-exercise-name', 'exl-muscle-group', 'exl-muscle-groups-secondary', 'exl-position', 'exl-movement', 'exl-equipment', 'exl-application', 'exl-accessories', 'exl-resistance-profile'];

  console.log({dynamicValueNames: dynamicValueNames});

  // var exLibOptions = {
  //   valueNames: dynamicValueNames,
  //   page: 12,
  //   pagination: [{
  //     name: 'exlib-pg-top',
  //     paginationClass: 'exlib-pg-top',
  //     innerWindow: 3,
  //     left: 2,
  //     right: 4
  //   },
  //   // {
  //   //   name: 'exlib-pg-top',
  //   //   paginationClass: 'exlib-pg-bot',
  //   //   innerWindow: 3,
  //   //   left: 2,
  //   //   right: 4
  //   // }
  // ],
  //   // pagination: true,
  //   fuzzySearch: true,
  //   // fuzzySearch: {
  //   //   searchClass: 'fuzzy-search',
  //   //   location: 0,
  //   //   distance: 40,
  //   //   threshold: 0.0,
  //   //   multiSearch: true
  //   // },
  //
  //   // plugins: [
  //   //   ListPagination({}),
  //     // ListPagination(pgBotOptions),
  //     // ListFuzzySearch()
  //     // ListFuzzySearch(exLibFuzzyOptions)
  //   // ]
  // };

  var exLibOptions = {
    valueNames: dynamicValueNames,
    page: 12,
    pagination: [{
      name: 'exlib-pg-top',
      paginationClass: 'exlib-pg-top',
      innerWindow: 3,
      left: 2,
      right: 4
    }, {
      name: 'exlib-pg-bot',
      paginationClass: 'exlib-pg-bot',
      innerWindow: 3,
      left: 2,
      right: 4
    }],
    // pagination: true,
    // fuzzySearch: {
    //   searchClass: "fuzzy-search",
    //   location: 0,
    //   distance: 100,
    //   threshold: 0.4,
    //   multiSearch: true
    // }
  };

  // List JS For Exercise Library
  var exLibList = new List('exercise-library-list', exLibOptions );
  exLibList.sort('exl-exercise-name', {order: 'asc'});
  //console.log(window.location.href);

  // Overwrite List JS search module to only search '.exl-exercise-name' on keyup press
  // $('.exlib-search-module').on('keyup', function() {
  //   active_search = $(this).val();
  //   //console.log(active_search);
  //   exLibList.fuzzySearch.search(active_search, [
  //     'exl-exercise-name',
  //     // 'exl-muscle-group',
  //     // 'exl-position',
  //     // 'exl-movement',
  //     // 'exl-equipment',
  //     // 'exl-application',
  //     // 'exl-accessories',
  //     // 'exl-resistance-profile'
  //   ]);
  // });

  var exLibFilter = {
    exl_muscle_group: [],
    exl_muscle_groups_secondary: [],
    exl_position: [],
    exl_movement: [],
    exl_equipment: [],
    exl_application: [],
    exl_accesories: [],
    exl_resistance_profile: []
  };

  function exLibSearchFunc(value) {
          //console.log({value: value});
          // var category_id = $(this).context.activeElement.id.replace(/-selectized/u, '');
          // var category_class = $('#'+category_id).attr('data-category');

          // SELECTIZE INCLUSION CONFIG: Builds the "search_object_inc" Search Object
                var search_object_inc = {};
                var selectize_inclusions = $('select.selectize-inclusion');
                var result_categories_count_inc = 0;
                var active_items_count_inc = 0;

                console.log({selectize_inclusion_data: {selectize_inclusions: selectize_inclusions, selectize_inclusions_length: selectize_inclusions.length}});

                selectize_inclusions.each(function() {
                      var this_select = $(this);
                      var this_select_id = $(this).attr('id');
                      var data_category = $(this).attr('data-category');
                      if(typeof data_category !== "undefined") {
                            var data_category_und = data_category.replace(/-/g, '_');
                            var data_value = $('#'+this_select_id).siblings('.selectize-control').find('.item').toArray();
                            // console.log({the_data_value: data_value});
                            if(this_select_id !== undefined && data_value.length !== 0) {
                                  console.log({this_select_id: $(this).attr('id'), data_category_und: data_category_und, data_value: data_value, exLibList_items: exLibList.items});
                                  var data_value_array = new Array();
                                  for(i = 0; i < data_value.length; i++) {
                                      data_value_array.push(data_value[i].dataset.value);
                                  }
                                  //search_object_inc.push({data_category: data_category, data_value: data_value});
                                  search_object_inc[data_category_und] = data_value_array;
                                  result_categories_count_inc++;
                                  active_items_count_inc = active_items_count_inc + data_value_array.length;
                            }
                      }
                });
          // END: SELECTIZE INCLUSION CONFIG

          // SELECTIZE EXCLUSION CONFIG: Builds the "search_object_exc" Search Object
                var search_object_exc = {};
                var selectize_exclusions = $('select.selectize-exclusion');
                var result_categories_count_exc = 0;
                var active_items_count_exc = 0;

                console.log({selectize_exclusion_data: {selectize_exclusions: selectize_exclusions, selectize_exclusions_length: selectize_exclusions.length}});

                selectize_exclusions.each(function() {
                      var this_select = $(this);
                      var this_select_id = $(this).attr('id');
                      var data_category = $(this).attr('data-category');
                      if(typeof data_category !== "undefined") {
                            var data_category_und = data_category.replace(/-/g, '_');
                            var data_value = $('#'+this_select_id).siblings('.selectize-control').find('.item').toArray();
                            if(this_select_id !== undefined && data_value.length !== 0) {
                                  var data_value_array = new Array();
                                  for(i = 0; i < data_value.length; i++) {
                                    data_value_array.push(data_value[i].dataset.value);
                                  }

                                  search_object_exc[data_category_und] = data_value_array;
                                  result_categories_count_exc++;
                                  active_items_count_exc = active_items_count_exc + data_value_array.length;
                            }
                      }
                });
          // END: SELECTIZE EXCLUSION CONFIG

          console.log({
            inclusion_criteria: {   // INCLUSION CRITERIA
                  result_categories_count_inc: result_categories_count_inc,
                  search_object_inc: search_object_inc,
                  active_items_count_inc: active_items_count_inc
            },
            exclusion_criteria: { // EXCLUSION CRITERIA
                  result_categories_count_exc: result_categories_count_exc,
                  search_object_exc: search_object_exc,
                  active_items_count_exc: active_items_count_exc
            }
          });

          console.log('-----------------------------');

          // var list_custom_search_class = $('.list-custom-search');
          // var list_custom_search = exLibTextSearch(list_custom_search_class);
          //
          // console.log({list_custom_search: list_custom_search});

          // EXECUTE exLibList FILTER FUNCTION
          if(active_items_count_inc > 0 || active_items_count_exc > 0) { // result_categories_count_inc > 0 || result_categories_count_exc > 0
                console.log('exLibList.filter()');
                var search_string = $('.list-custom-search').val().toLowerCase().toString();
                var search_split = search_string.split(' ');

                exLibList.filter(function(item) {
                      // console.log({category_class: category_class, item: item, item_names: Object.getOwnPropertyNames(item.values()), value: value});

                      //*** BEGIN SEARCH TEXT FILTER PORTION OF SEARCH ALGORITHM ***//
                      var exercise_name = item.values()['exl-exercise-name'].toLowerCase().toString();
                      var name_split = exercise_name.split(' ');
                      var name_split_length = name_split.length;
                      // ONE OF TWO TRUTH PILLARS FOR FILTER RESULT
                      var truth_string_match;

                      var alphabetical = [];
                      for(i = 0; i < name_split_length; i++) {
                        var alphabetized = name_split[i].split('').sort().join('');
                        alphabetical.push(alphabetized);
                      }

                      var index_of_exact = exercise_name.includes(search_string);
                      var search_split_length = search_split.length;
                      var aoa_match = 0;
                      var bob_match = 0;

                      if(index_of_exact === true) {
                        var truth_string_match = true;
                      } else if(search_split_length > 0) {
                        //console.log('search_split_mode');

                        for(i = 0; i < search_split_length; i++) {
                          if(new RegExp(search_split[i]).test(exercise_name)) {
                            aoa_match++;
                          }
                        }

                        if(aoa_match === search_split_length) {
                          var truth_string_match = true;
                        } else {
                          var alphabetical_search = [];
                          for(v = 0; v < search_split_length; v++) {
                            var alphabetized_search = search_split[v].split('').sort().join('');
                            alphabetical_search.push(alphabetized_search);
                          }
                          var alphabetical_search_length = alphabetical_search.length;
                          for(w = 0; w < alphabetical_search_length; w++) {
                            // if(new RegExp(alphabetical_search[w]).test(alphabetical.join(' '))) {
                            if(alphabetical.indexOf(alphabetical_search[w]) > -1) {
                              bob_match++;
                            }
                          }
                          if(bob_match === alphabetical_search_length) {
                            var truth_string_match = true;
                          }
                        }

                      } else {
                        var truth_string_match = false;
                      }

                      //*** BEGIN CATEGORY FILTER PORTION OF SEARCH ALGORITHM ***//
                      // TWO OF TWO TRUTH PILLARS FOR CATEGORY PORTION OF SEARCH ALGORITHM
                      var truth_category_match;
                      // Extract the "Names" of the item.values() Object's "Name/Value" Pairs
                      var item_props = Object.getOwnPropertyNames(item.values());
                      //console.log({item: item, item_props: item_props});
                      // Define search match exact counter
                      var search_exact_inc = 0;
                      var search_exact_exc = 0;
                      // Loop through the Item Property Names of the current Item
                      for(p = 0; p < item_props.length; p++) {
                            // Select the current Item Property and swap dashes for underscores to use in object bracket method injection
                            var item_prop = item_props[p].replace(/-/g, '_');
                            //console.log({item_prop: item_prop});
                            // define current Item Properties
                            var item_values = item.values();
                            // If current Inclusion Item Property is defined and value array greater than 0
                            // typeof search_object_inc[item_prop] !== "undefined"
                            if(typeof search_object_inc[item_prop] !== "undefined") {
                                if(search_object_inc[item_prop].length > 0) {
                                        // Count the length of the current item property in the search object
                                        var search_object_inc_length = search_object_inc[item_prop].length;
                                        // Loop through Search Object's current item property [object bracket method injection]
                                        for(m = 0; m < search_object_inc_length; m++) {
                                              //console.log({search_object_inc_match: search_object_inc[item_prop][m].dataset.value, item_values: item_values});
                                              // Select current Search Value in Search Object Item Property Array
                                              var current_search_value = search_object_inc[item_prop][m]; // .dataset.value;
                                              // Select Current Item's values stored as array in string parsed by JSON
                                              if(item_values[item_props[p]] != "") {
                                                var current_item_values = JSON.parse(item_values[item_props[p]]);
                                                // If Current Search Value is Indexed/Found Matched in Current Item's Array of Values, Increment Search Exact
                                                if(current_item_values.indexOf(current_search_value) >= 0) {
                                                  search_exact_inc = search_exact_inc + 1;
                                                }
                                              }
                                        }
                                        //console.log({search_exact_inc: search_exact_inc, search_object_inc_length: search_object_inc_length});
                                }
                            }
                            // If current Exclusion Item Property is defined and value array greater than 0
                            if(typeof search_object_exc[item_prop] !== "undefined") {
                                if(search_object_exc[item_prop].length >0) {
                                      // Count the length of the current item property in the search object
                                      var search_object_exc_length = search_object_exc[item_prop].length;
                                      // Loop through Search Object's current item property [object bracket method injection]
                                      for(m = 0; m < search_object_exc_length; m++) {
                                            //console.log({search_object_inc_match: search_object_inc[item_prop][m].dataset.value, item_values: item_values});
                                            // Select current Search Value in Search Object Item Property Array
                                            var current_search_value_exc = search_object_exc[item_prop][m]; // .dataset.value;
                                            // Select Current Item's values stored as array in string parsed by JSON
                                            if(item_values[item_props[p]] != "") {
                                              var current_item_values_exc = JSON.parse(item_values[item_props[p]]);
                                              // If Current Search Value is Indexed/Found Matched in Current Item's Array of Values, Increment Search Exact
                                              if(current_item_values_exc.indexOf(current_search_value_exc) >= 0) {
                                                search_exact_exc = search_exact_exc + 1;
                                              }
                                            }
                                      }
                                      //console.log({search_exact_exc: search_exact_exc, search_object_exc_length: search_object_exc_length});
                                }
                            }

                      } // end for loop

                      if(active_items_count_inc > 0 || active_items_count_exc > 0) {
                        if(active_items_count_inc > 0 && active_items_count_exc > 0) {
                          //console.log({item: item, status: 'INC > 0 && EXC > 0'});
                          if(search_exact_inc === active_items_count_inc && search_exact_exc === 0) { // && search_exact_exc !== active_items_count_exc
                            var truth_category_match = true;
                          } else {
                            var truth_category_match = false;
                          }
                        } else if(active_items_count_inc > 0 && active_items_count_exc === 0) {
                          //console.log({item: item, status: 'INC > 0, EXC == 0'});
                          if(search_exact_inc === active_items_count_inc) {
                            var truth_category_match = true;
                          } else {
                            var truth_category_match = false;
                          }
                        } else if(active_items_count_exc > 0 && active_items_count_inc === 0) {
                          //console.log({item: item, status: 'EXC > 0, INC == 0'});
                          //return false;
                          if(search_exact_exc > 0) { // was search_exact_exc === active_items_count_exc
                            var truth_category_match = false;
                          } else {
                            var truth_category_match = true;
                          }
                        } else {
                          //console.log({item: item, status: 'DEFAULT RETURN TRUE'});
                          var truth_category_match = true;
                        }
                      }

                      // Ultimate determination if Item will be returned by filter
                      if(search_string != "") {
                        if(truth_string_match === true && truth_category_match === true) {
                          return true;
                        } else {
                          return false;
                        }
                      } else {
                        if(search_string == "" && truth_category_match === true) {
                          return true;
                        } else {
                          return false;
                        }
                      }

                }); // end .filter(function(item, value){});
            }
            console.log('-----------------------------');

            if(result_categories_count_inc === 0 && result_categories_count_exc === 0) {
                console.log('reset search');
                exLibList.filter(function(item) {return true;});
            } // end if value !== null

            // Sort Outcome
            exLibList.sort('exl-exercise-name', {order: 'asc'});

  } // END: exLibSearchFunc(value);



// exLibList.filter(function(item) {
//   console.log(JSON.parse(item.values()['exl-equipment']));
//   var search_val = "Prime Fitness";
//   var data_array = JSON.parse(item.values()['exl-equipment']);
//   var data_check = data_array.indexOf(search_val) >= 0;
//   return data_check;
// });

  // SelectizeJS for Inclusion Search Categories
  var selectize_inclusion = $('.selectize-inclusion').selectize({
    max_items: 25,
    onChange: function(value) {
      exLibSearchFunc(value);
    },

  });

  // SelectizeJS for Exclusion Search Categories
  var selectize_exclusion = $('.selectize-exclusion').selectize({
    max_items: 25,
    onChange: function(value) {
      exLibSearchFunc(value);
    },

  });

  $('.list-custom-search').on('keyup', function() {
    var current_this = $(this);
    exLibTextSearch(current_this);
  });

  function exLibTextSearch(current_this) {
        var search_string = current_this.val().toLowerCase().toString();
        var search_split = search_string.split(' ');
        //console.log(search_string);
        // exLibList.fuzzySearch(search_string);
        if($('.selectize-input .item').length > 0) {
          console.log({selectize_input_item_lengt: $('.selectize-input .item').length});
          exLibSearchFunc();
        } else {
              exLibList.filter(function(item) {
                // Lines 388 - 435 (or the next 47 lines) have been refactored into category search filter algorithm
                    var exercise_name = item.values()['exl-exercise-name'].toLowerCase().toString();
                    var name_split = exercise_name.split(' ');
                    var name_split_length = name_split.length;
                    var alphabetical = [];
                    for(i = 0; i < name_split_length; i++) {
                      var alphabetized = name_split[i].split('').sort().join('');
                      alphabetical.push(alphabetized);
                    }

                    var index_of_exact = exercise_name.includes(search_string);
                    var search_split_length = search_split.length;
                    var aoa_match = 0;
                    var bob_match = 0;

                    if(index_of_exact === true) {
                      return true;
                    } else if(search_split_length > 0) {
                      //console.log('search_split_mode');

                      for(i = 0; i < search_split_length; i++) {
                        if(new RegExp(search_split[i]).test(exercise_name)) {
                          aoa_match++;
                        }
                      }

                      if(aoa_match === search_split_length) {
                        return true;
                      } else {
                        var alphabetical_search = [];
                        for(v = 0; v < search_split_length; v++) {
                          var alphabetized_search = search_split[v].split('').sort().join('');
                          alphabetical_search.push(alphabetized_search);
                        }
                        var alphabetical_search_length = alphabetical_search.length;
                        for(w = 0; w < alphabetical_search_length; w++) {
                          // if(new RegExp(alphabetical_search[w]).test(alphabetical.join(' '))) {
                          if(alphabetical.indexOf(alphabetical_search[w]) > -1) {
                            bob_match++;
                          }
                        }
                        if(bob_match === alphabetical_search_length) {
                          return true;
                        }
                      }

                    } else {
                      return false;
                    }
              });
        }
  }


  // $('#exlib-category-checkboxes input.form-check-input').attr('checked', false);

  // Input Checkbox on Click Reveal Selectize Search Filter Category Row
  $('#exlib-category-checkboxes .form-check-input').on('change', function() {

        $(this).toggleClass('selectize-checked');
        var checkbox_name = $(this).next().text();
        var selectize_module = $(this).attr('data-selectize-module');
        var selectize_category = $(this).attr('data-selectize-category');

        // if($(this).hasClass('selectize-checked') === false) {
        //   $(selectize_category)[0].selectize.removeOption(1);
        // }

        console.log(selectize_module);
        $(selectize_module).toggleClass('no-height display-none');
        var count_actives = $('#exlib-category-checkboxes .form-check-input:checked').length;
        console.log(count_actives);

        var module_header = $('#exlib-selectize table tr:nth-child(1)');

        if(count_actives > 0) {
          module_header.removeClass('no-height display-none');
        } else {
          module_header.addClass('no-height display-none');
        }

        if($(this).is(':checked') === false) {
              var alert_module = '<div class="alert alert-warning alert-dismissible fade show my-4 mr-2" role="alert">'
                                + '<div class="module-message"><strong>Hey!</strong> You have category filter values in <strong>'+checkbox_name+'</strong></div>'
                                + '<div class="module-list-include"><strong>Inclusion:</strong> </div>'
                                + '<div class="module-list-exclude"><strong>Exclusion:</strong> </div>'
                                +'<button type="button" class="close" data-dismiss="alert" aria-label="Close">'
                                +'<span aria-hidden="true">&times;</span>'
                                +'</button>'
                                +'</div>';
              console.log('input is unchecked');
              var count_this_includes_active = $(selectize_category+' ~ .selectize-control .item');
              var count_this_excludes_active = $(selectize_category+'-exclude ~ .selectize-control .item');
              if(count_this_includes_active.length > 0 || count_this_excludes_active > 0) {
                $('#exlib-alert-catcher').append(alert_module);
                count_this_includes_active.each(function() {
                  $(this).clone().addClass('badge badge-success').appendTo('#exlib-alert-catcher .alert .module-list-include');
                });
                count_this_excludes_active.each(function() {
                  $(this).clone().addClass('badge badge-danger').appendTo('#exlib-alert-catcher .alert .module-list-exclude');
                });
              }
        }

  });

  // Enable Bootstrap 4 Popover JS Everywhere
  $(function () {$('[data-toggle="popover"]').popover()});

  // Add Class to Fuzzy Search Input after page load
  // $('.fuzzy-search').addClass('exlib-search-module form-control');


});
