<?php
$today = date('Ymd');
$event_args = array(
    'post_type' => 'events',
    'posts_per_page' => -1,
    'meta_key' => 'start_date',
    'meta_query' => array(
      array('relation' => 'AND'),
      array('key' => 'start_date', 'value' => $today)
    ),
    'orderby' => 'meta_value',
    'order' => 'DESC'
);

$past_event_args = $event_args;
$past_event_args['meta_query'][1]['compare'] = '<=';
$upcoming_event_args = $event_args;
$upcoming_event_args['meta_query'][1]['compare'] = '>=';

$past_events = new WP_Query($past_event_args);
$upcoming_events = new WP_Query($upcoming_event_args);

console_log(array(
  'pea' => $past_event_args,
  'uea' => $upcoming_event_args,
  'pe'  => $past_events,
  'ue'  => $upcoming_events
));

?>
<style>
  .community-header {font-size:3.5rem;}
  @media screen and (max-width:991px) {.community-header {font-size:2.5rem;}}
</style>
<?php if($upcoming_events->have_posts()): ?>
  <div id="upcoming-events">

    <div class="gg-calypso px-3 py-5 text-center fw-900">
      <h2 class="event-header text-uppercase fw-900 gg-light-text">Upcoming Events</h2>
    </div>

    <div class="container-fluid px-0 gg-light">
      <div class="centerize ctz-lg px-3 py-5">
        <div class="loop-events">
          <?php
            while($upcoming_events->have_posts()): $upcoming_events->the_post();
              get_template_part('/loops/loop-event');
            endwhile; wp_reset_query();
          ?>
        </div>
      </div>
    </div>

  </div>
<?php endif; ?>

<div id="past-events">

  <div class="gg-calypso px-3 py-5 text-center fw-900">
    <h2 class="event-header text-uppercase fw-900 gg-light-text">Past Events</h2>
  </div>

  <div class="container-fluid px-0 gg-light">
    <div class="centerize ctz-lg px-3 py-5">
      <div class="loop-events">
        <?php
          if($past_events->have_posts()): while($past_events->have_posts()): $past_events->the_post();
            get_template_part('/loops/loop-event');
          endwhile; wp_reset_query(); endif;
        ?>
      </div>
    </div>
  </div>

</div>
