<?php
  $post_args = array('post_type' => 'post', 'posts_per_page' => -1, 'orderby' => 'date', 'order' => 'DESC');
  $atel_posts = new WP_Query($post_args);
  if($atel_posts->have_posts()):
?>

<style>.hidden {display:none !important;}</style>

<div id="atel-posts-search" class="gg-japanese-laurel">
  <div class="centerize ctz-lg px-3 py-5">
    <div class="form-group">
      <input id="search-posts" class="form-control" placeholder="Search News..." />
    </div>
    <div id="results-counter" class="text-center atel-white-text pt-3"></div>
  </div>
</div>

<div id="atel-posts" class="gg-light">
  <div class="centerize ctz-lg px-3 py-5">

      <div id="atel-posts-archive">

          <?php
            while($atel_posts->have_posts()): $atel_posts->the_post();
                get_template_part('/loops/loop-post');
            endwhile; wp_reset_query();
          ?>

          <div id="no-results" class="hidden">
            <div class="gangagen-card">
              <div class="gangagen-card-body text-center">
                <p class="h4 gg-calypso-text">Sorry, no results found...</p>
              </div>
            </div>
          </div>

      </div>

  </div>
</div>

<script>

  // Array in Array in Anyway you say?
  function aia(haystack, needle) {
    var found = [];
    for(n = 0; n < needle.length; n++) {
      if(haystack.indexOf(needle[n]) >= 0) {
        found.push(needle[n]);
      } else {
        for(h = 0; h < haystack.length; h++) {
          if(haystack[h].includes(needle[n])) {
            found.push(needle[n]);
          }
        }
      }
    }
    return found;
  }

  // Search Input
  var search_posts = document.getElementById('search-posts');

  // Keystroke Filter Function
  search_posts.addEventListener('keyup', function(e) {
    e.preventDefault();
    var search_string = this.value.toLowerCase();
    var split_search = search_string.replace('.', '').split(' ');
    var news = document.querySelectorAll('.loop-post');
    var results_counter = document.querySelector('#results-counter');
    var no_results = document.querySelector('#no-results')
    var counter = 0;
    var log = {yes: [], no: []};
    news.forEach(n => {
      n.classList.add('hidden');
      n.setAttribute('data-includes', 0)
      n.setAttribute('data-aia', 0);
      var title = n.querySelector('h2').innerHTML.toLowerCase();
      var split_title = title.replace('.', '').split(' ');
      var in_array = aia(split_title, split_search);
      if(title.includes(search_string) || in_array.length > 0) {
        n.classList.remove('hidden'); counter++;
        n.setAttribute('data-includes', title.includes(search_string) ? 1 : 0)
        n.setAttribute('data-aia', in_array.length > 0 ? in_array.length : 0);
        log.yes.push({status: 'YES', title: title, split_title: split_title, includes: title.includes(search_string), in_array: in_array});
      } else {
        log.no.push({status: 'NO', title: title, split_title: split_title, includes: title.includes(search_string), in_array: in_array});
      }
    });
    if(counter > 0) {
      results_counter.innerHTML = `${counter} Result${counter > 1 ? 's' : ''} Found`;
      no_results.classList.add('hidden');
    } else {
      results_counter.innerHTML = "";
      no_results.classList.remove('hidden');
    }
    console.log({search_string: search_string, split_search: split_search, log: log});
  });

</script>

<?php endif; ?>
