<?php
    if(have_posts()): while(have_posts()): the_post();
?>
  <style>
    h2, h4, h6 {color: var(--gg-japanese-laurel);}
    h3, h5 {color: var(--gg-golden-bell);}
  </style>
  <div id="single-post-<?php echo $post->post_name; ?>">
    <div id="single-post-header-<?php echo $post->post_name; ?>" class="px-3 py-5 gg-japanese-laurel">
      <div id="single-post-title-<?php echo $post->post_name; ?>" class="single-post-title text-center">
        <h1 class="abx-white-text" style=""><?php echo get_the_title(); ?></h1>
        <p class="text-center abx-white-text" style="">Published on <?php echo get_the_date(); ?></p>
      </div>
      <div id="single-post-meta-<?php echo $post->post_name; ?>" class="single-post-meta text-center">
        <img src="<?php echo get_avatar_url($post->post_author); ?>" style="width:96px;height:96px;border-radius:50%;" />
        <p class="mb-0 abx-white-text">written by</p>
        <h6 class="abx-white-text"><?php echo get_the_author_meta('display_name', $post->post_author); ?></h6>
      </div>
    </div>
    <div id="single-post-body-<?php echo $post->post_name; ?>" class="centerize ctz-md px-3 py-5">
      <div id="single-post-content <?php $post->post_name; ?>" class="single-post-content">
        <div class="">
            <?php the_content(); ?>
        </div>
      </div>
      <div id="single-post-flex-content <?php echo $post->post_name; ?>" class="single-post-flex-content">
          <?php get_template_part('/flex/flex'); ?>
      </div>
      <?php if(get_field('citations')): ?>
        <div id="single-post-citations <?php echo $post->post_name; ?>" class="single-post-citations">
          <?php while(has_sub_field('citations')): ?>
            <?php $source_type = get_sub_field('source_type'); $link_or_file = get_sub_field($source_type); ?>
            <div class="citation-card">
              <div class="citation-card-title">
                <a href="<?php echo $link_or_file; ?>" <?php echo $source_type === 'file' ? 'download' : ''; ?>>
                  <h3><?php echo get_sub_field('title'); ?></h3>
                </a>
              </div>
              <div class="citation-card-source">
                <?php echo get_sub_field('citation'); ?>
              </div>
            </div>
          <?php endwhile; ?>
        </div>
      <?php endif; ?>
    </div>
  </div>
<?php
    endwhile; endif;
