<?php
  $evf = get_fields(); console_log(array('fields' => $evf));
  $strdate = strtotime($evf['start_date']);
  $enddate = strtotime($evf['end_date']);
  $is_tbd = get_field('is_tbd');
?>

<div id="single-event-address" class="gg-calypso">
    <div class="centerize ctz-xl px-3 py-5 text-center">
        <h2 class="abx-white-text">
          <?php if($strdate && $enddate && !$is_tbd): ?>
            <span class="fw-900"><?php echo date('F j', $strdate) . ' - ' . date('F j, Y', $enddate); ?></span><br/>
          <?php elseif($strdate && !$enddate && !$is_tbd): ?>
            <span class="fw-900"><?php echo date('F j, Y', strtotime(get_field('start_date'))); ?></span><br/>
          <?php elseif($is_tbd === true): ?>
            <p>To-Be-Determined</p>
          <?php endif; ?>
          <span class="fw-900"><?php echo $evf['address']; ?></span><br/>
          <span class="fw-900"><?php echo $evf['city'].', '.$evf['state'].', '.$evf['zip']; ?></span>
        </h2>
    </div>
</div>

<div id="single-event-description" class="gg-light">
    <div class="centerize ctz-xl px-3 py-5">
        <div class="row">
            <div class="col-12 col-md-6 order-2 order-md-1">
                <div class="event-description" style="font-size:1.2rem; line-height:2;">
                  <?php echo get_the_content(); ?>
                </div>
            </div>
            <div class="col-12 col-md-6 order-1 order-md-2">
                <iframe
                    style="width:100%;"
                    src="https://www.google.com/maps?q=<?php echo urlencode($evf['address'].', '.$evf['city'].', '.$evf['state'].', '.$evf['zip'].', '.$evf['country']); ?>&output=embed"
                    width="600"
                    height="450"
                    frameborder="0"
                    style="border:0;"
                    allowfullscreen=""
                    aria-hidden="false"
                    tabindex="0"
                ></iframe>
            </div>
    </div>
</div>

<?php if( isset($evf['event_gallery']) && count((array)$evf['event_gallery']) > 0): ?>
    <div id="single-event-gallery">
        <?php if(count($evf['event_gallery']) > 0): foreach($evf['event_gallery'] as $gallery): ?>
            <div class="single-event-gallery">
                <div class="container-fluid px-3 py-5 hbm-ocean-blue hbm-white-text text-center">
                    <h3 class="fw-900"><?php echo $gallery['gallery_title']; ?></h3>
                </div>
                <div class="container-fluid px-0">
                    <div class="centerize ctz-lg px-3 py-5">
                        <div class="gg-grid">
                            <?php if(count($gallery['images'])): foreach($gallery['images'] as $image): ?>
                                <img class="gg-grid-item mr-2 mb-2" src="<?php echo $image['image']; ?>" alt="<?php echo $image['title']; ?>" style="width:31%;" data-desc="<?php echo $image['description']; ?>" data-toggle="modal" data-target="#single-event-gallery-modal" />
                            <?php endforeach; endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        <?php endforeach; endif; ?>
        <div id="single-event-gallery-modal" class="modal">
          <div class="modal-dialog modal-lg">
            <div class="modal-content mt-5">
              <div class="modal-body">
                  <div class="text-right mb-2">
                    <button type="button" class="hbm-button" data-dismiss="modal"><i class="fa fa-close"></i></button>
                  </div>
                  <div class="text-center">
                    <img id="segm-image" src="#" alt="Gangagen" style="width:100%;" class="mb-3" />
                  </div>
                  <div>
                    <p class="segm-title h3 text-center fw-900 hbm-ocean-blue-text"></p>
                    <hr/>
                    <div class="segm-desc"></div>
                  </div>
              </div>
            </div>
          </div>
        </div>
    </div>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/masonry/4.2.2/masonry.pkgd.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.imagesloaded/4.1.4/imagesloaded.pkgd.min.js"></script>
    <script>
      jQuery(document).ready(function($) {
        $('.gg-grid').imagesLoaded(function() {
            $('.gg-grid').masonry({
                itemSelector: '.gg-grid-item'

            });
        });

        $('.gg-grid-item').on('click', function() {
            $('#segm-image').attr('src', $(this).attr('src'));
            $('.segm-title').empty().text($(this).attr('alt'));
            $('.segm-desc').empty().text($(this).attr('data-desc'));
        });
      })
    </script>
<?php endif; ?>
