<?php //Base Theme SEO - Admin Javascript ?>

<script>

var descCharacterLimits = 300;
var titlePixelLimit = 600;

if ($('#base-theme-seo-custom-web-title').length) {

  baseThemeSeoMetaTitleChanged();
  baseThemeSeoMetaDescChanged();
  baseThemeSeoScaleSimulator();

  $('#base-theme-seo-custom-web-title').keyup(function() {
    baseThemeSeoMetaTitleChanged();
  });

  $('#base-theme-seo-custom-web-description').keyup(function() {
    baseThemeSeoMetaTitleChanged();
    baseThemeSeoMetaDescChanged();
  });

  $(window).resize(function() {
    baseThemeSeoScaleSimulator();
  });
}

function baseThemeSeoScaleSimulator() {
  if ($('#base-theme-seo-google-simulator-headline').outerWidth() < 634) {
    $('#base-theme-seo-google-simulator').css('transform', 'scale(' + $('#base-theme-seo-google-simulator-headline').outerWidth() / 634 + ')')
  } else {
    $('#base-theme-seo-google-simulator').css('transform', '');
  }
}

function baseThemeSeoMetaTitleChanged() {
  var printout = '';
  var titlePixels = '';
  var title = $('#base-theme-seo-custom-web-title')[0].value;
  var desciption = $('#base-theme-seo-custom-web-description')[0].value;

  if (title.length <= 0) {
    title = $('#base-theme-seo-custom-web-title').attr("placeholder");
  }

  if (desciption.length == 0) {
    desciption = $('#base-theme-seo-custom-web-description').attr("placeholder");
  }

  desciption = desciption.replace(/\</g,'&lt;');
  title = title.replace(/\</g,'&lt;');
  $('#base-theme-seo-google-simulator h3')[0].innerHTML = '<span>' + title + '</span>';
  $('#base-theme-seo-google-simulator p')[0].innerHTML = desciption;


  titlePixels = $('#base-theme-seo-google-simulator h3 span').width();

  printout += '<div id="web-title-bar-wrapper" class="under-textarea-info-wrapper"><div id="web-title-bar" class="under-textarea-info">' + '</div></div>';
  printout += '<div>' + titlePixels + ' out of ' + titlePixelLimit + ' pixels used</div>';
  $('#base-theme-seo-meta-title-info')[0].innerHTML = printout;

  $('#web-title-bar').css('width', titlePixels / titlePixelLimit * 100 + '%');
  //red rgb(255, 0, 0)
  //yellow rgb(255, 255, 0)
  //green rgb(0, 165, 0)

  if (titlePixels > titlePixelLimit) {
    $('#web-title-bar').css('backgroundColor', 'rgb(255, 0, 0)')
  } else if (titlePixels / titlePixelLimit < .5){
    var green = 255 * (titlePixels/titlePixelLimit) * 2;

    if (green < 0) {
      green = 0;
    } else {
      green = Math.round(green);
    }

    $('#web-title-bar').css('backgroundColor', 'rgb(' + 255 + ', ' + green + ', 0)')
  } else {
    var red = 255 - 255 * ((titlePixels - titlePixelLimit/2)/(titlePixelLimit/2));
    var green = 255 - 90 * ((titlePixels - titlePixelLimit/2)/(titlePixelLimit/2));

    if (red < 0) {
      red = 0;
    } else {
      red = Math.round(red);
    }
    if (green < 0) {
      green = 0;
    } else {
      green = Math.round(green);
    }

    $('#web-title-bar').css('backgroundColor', 'rgb(' + red + ', ' + green + ', 0)')
  }

}

function baseThemeSeoMetaDescChanged() {
  var printout = '';
  var descLength = $('#base-theme-seo-custom-web-description')[0].value.length;

  if (descLength == 0) {
    descLength = $('#base-theme-seo-custom-web-description').attr("placeholder").length;
  }
  printout += '<div id="web-desc-bar-wrapper" class="under-textarea-info-wrapper"><div id="web-desc-bar" class="under-textarea-info">' + '</div></div>';
  printout += '<div>' + descLength + ' out of ' + descCharacterLimits + ' characters used</div>';

  $('#base-theme-seo-meta-description-info')[0].innerHTML = printout;

  $('#web-desc-bar').css('width', descLength / descCharacterLimits * 100 + '%');
  //red rgb(255, 0, 0)
  //yellow rgb(255, 255, 0)
  //green rgb(0, 165, 0)
  if (descLength > descCharacterLimits || descLength < 50) {
    $('#web-desc-bar').css('backgroundColor', 'rgb(255, 0, 0)')
  } else {
    //var red = 255 - 255 * ((descLength - descCharacterLimits/6)/(descCharacterLimits/6));
    var red = 306 - 1.02 * descLength;
    var green = 273 - 0.36 * descLength;

    if (red < 0) {
      red = 0;
    } else {
      red = Math.round(red);
    }
    if (green < 0) {
      green = 0;
    } else {
      green = Math.round(green);
    }

    $('#web-desc-bar').css('backgroundColor', 'rgb(' + red + ', ' + green + ', 0)');
  }

}

</script>
