<?php //Base Theme SEO - Admin Javascript ?>

<script>


class TabsObject {
  constructor(tabId, regularTabs, linkClassName, contentClassName) {
    if (!tabId) throw new Error("tabId not specified for TabsObject");
    if (!regularTabs && typeof regularTabs !== "boolean") regularTabs = true;
    if (!linkClassName) linkClassName = "tabs_link";
    if (!contentClassName) contentClassName = "tabs_content";
    //functions
    this.getTabs = function() {
      var tabsHolder = document.querySelectorAll("[tabs_id=" + tabId + "]")[0];
      var theLinks = [];
      var theContent = [];
      var tabShown = tabsHolder.hasAttribute("start")
      ? tabsHolder.getAttribute("start") - 1
      : 0;

      for (var i = 0; i < tabsHolder.children.length; i++) {
        if (tabsHolder.children[i].className.includes(linkClassName)) {
          theLinks.push(tabsHolder.children[i]);
        } else if (tabsHolder.children[i].className.includes(contentClassName)) {
          theContent.push(tabsHolder.children[i]);
        }
      }

      if (theLinks.length !== theContent.length) {
        throw "Need the same amount of links as content";
      }

      //Add First and last to first and last of content and link
      jQuery(theLinks[0]).addClass("first");
      jQuery(theContent[0]).addClass("first");
      jQuery(theLinks[theLinks.length-1]).addClass("last");
      jQuery(theContent[theContent.length-1]).addClass("last");


      for (i = 0; i < theLinks.length; i++) {
        var rand = Math.floor(Math.random() * Number.MAX_SAFE_INTEGER);
        theLinks[i].setAttribute("tabs_id", linkClassName + rand);
        theLinks[i].setAttribute("tabs_active", "true");
        theContent[i].setAttribute("tabs_id", contentClassName + rand);
        jQuery(theLinks[i]).click(changeTab);
      }

      function changeTab(mouseEvent) {
        for (i = 0; i < theContent.length; i++) {
          var current = mouseEvent.target;
          var parent = current.parentElement;
          var target_tabID;
          if (current.hasAttribute("tabs_id"))
            target_tabID = current.getAttribute("tabs_id") ;

          for (var j = 0; j < 1048576; j++) {
            if (target_tabID) break;
            else {

              current = parent;
              parent = current.parentElement;
              if (current.hasAttribute("tabs_id"))
                target_tabID = current.getAttribute("tabs_id") ;
            }
          }
          if(regularTabs) {
            if (target_tabID !== theLinks[i].getAttribute("tabs_id")) {
              jQuery(theContent[i]).removeClass("tabs_show");
              jQuery(theContent[i]).addClass("tabs_hide");
              theLinks[i].setAttribute("tabs_active", "false");
            } else {
              jQuery(theContent[i]).removeClass("tabs_hide");
              jQuery(theContent[i]).addClass("tabs_show");
              theLinks[i].setAttribute("tabs_active", "true");
            }
          } else if (target_tabID == theLinks[i].getAttribute("tabs_id")) {
            if (jQuery(theContent[i]).hasClass("tabs_show")) {
              jQuery(theContent[i]).removeClass("tabs_show");
              jQuery(theContent[i]).addClass("tabs_hide");
              theLinks[i].setAttribute("tabs_active", "false");
            } else {
              jQuery(theContent[i]).removeClass("tabs_hide");
              jQuery(theContent[i]).addClass("tabs_show");
              theLinks[i].setAttribute("tabs_active", "true");
            }
          }

          /*if (target_tabID !== theLinks[i].getAttribute("tabs_id")) {
	            jQuery(theContent[i]).removeClass("tabs_show");
	            jQuery(theContent[i]).addClass("tabs_hide");
							theLinks[i].setAttribute("tabs_active", "false");
	          } else if (target_tabID == theLinks[i].getAttribute("tabs_id")){
	            jQuery(theContent[i]).removeClass("tabs_hide");
	            jQuery(theContent[i]).addClass("tabs_show");
							theLinks[i].setAttribute("tabs_active", "true");
	          } */
        }
      }

      for (i = 0; i < theContent.length; i++) {
        if (i != tabShown) {
          jQuery(theContent[i]).removeClass("tabs_show");
          jQuery(theContent[i]).addClass("tabs_hide");
          theLinks[i].setAttribute("tabs_active", "false");
        } else {
          jQuery(theContent[i]).removeClass("tabs_hide");
          jQuery(theContent[i]).addClass("tabs_show");
          theLinks[i].setAttribute("tabs_active", "true");
        }
      }
    };

    //variables
    this.tabs = this.getTabs();
  }
}

if (document.getElementsByClassName("base_theme_seo_tabs_wrapper").length ) {
  var tabs = document.getElementsByClassName("base_theme_seo_tabs_wrapper");
  tabs[0].setAttribute("tabs_id", "base_theme_seo_tabs_wrapper");
  var tabObjects = new TabsObject(tabs[0].getAttribute("tabs_id"), true);
}

//var newTab = new TabsObject("tabs001", true);


</script>
