<?php //Base Theme SEO - The meta boxes that will be displayed in the posts/pages/custom post types

// exit if file is called directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


// display meta box
function base_theme_seo_display_meta_box( $post ) {
  $post_id = $post->ID;

  $post_custom_meta = get_post_meta($post_id, '_base_theme_seo_post_custom_meta', true);

  $web_custom_title = isset($post_custom_meta['title']) ? $post_custom_meta['title'] : '';
	$web_custom_description = isset($post_custom_meta['description']) ? $post_custom_meta['description'] : '';

  $facebook_custom_title = isset($post_custom_meta['facebook-title']) ? $post_custom_meta['facebook-title'] : '';
	$facebook_custom_description = isset($post_custom_meta['facebook-description']) ? $post_custom_meta['facebook-description'] : '';
	$facebook_custom_image = isset($post_custom_meta['facebook-image']) ? $post_custom_meta['facebook-image'] : '';

  $twitter_custom_title = isset($post_custom_meta['twitter-title']) ? $post_custom_meta['twitter-title'] : '';
	$twitter_custom_description = isset($post_custom_meta['twitter-description']) ? $post_custom_meta['twitter-description'] : '';
	$twitter_custom_image = isset($post_custom_meta['twitter-image']) ? $post_custom_meta['twitter-image'] : '';

  $post_generated_meta = get_post_meta($post_id, '_base_theme_seo_post_generated_meta', true);

  $web_generated_title = isset($post_generated_meta['title']) ? $post_generated_meta['title'] : '';
  $web_generated_description = isset($post_generated_meta['description']) ? $post_generated_meta['description'] : '';

  $facebook_generated_description = isset($post_generated_meta['facebook-description']) ? $post_generated_meta['facebook-description'] : '';

  $twitter_generated_description = isset($post_generated_meta['twitter-description']) ? $post_generated_meta['twitter-description'] : '';


	wp_nonce_field( basename( __FILE__ ), 'base_theme_seo_meta_box_nonce' );

	?>

  <!-- WEB METAS
    https://webmasters.googleblog.com/2009/09/google-does-not-use-keywords-meta-tag.html
    https://moz.com/search-ranking-factors
  -->
  <!-- https://moz.com/learn/seo/title-tag // Max Length 50-60 char -->
	<div class="base_theme_seo_tabs_wrapper">
		<div class="tabs_link" >SEO</div>
	  <div class="tabs_link" >Facebook</div>
	  <div class="tabs_link" >Twitter</div>
		<div class="tabs_content">
			<h4 id="base-theme-seo-google-simulator-headline">Google Preview</h4>
			<div id="base-theme-seo-google-simulator" class="">
				<h3></h3>
				<cite><?php the_permalink(); ?> <span class="mn-dwn-arw"></span></cite>
				<p></p>
			</div>
		  <label for="base-theme-seo-custom-web-title">Meta Title
		    <span class="base-theme-seo-tooltip">?
		      <span class="base-theme-seo-tooltiptext">The title of the page. Will be shown on the tab for that page, and will be the title of the Search. Recommended no more that 50-60 characters. Characters must fit in 600px</span>
		    </span>
		  </label>
		  <textarea rows="2" class="base-theme-seo-textarea" id="base-theme-seo-custom-web-title" name="base-theme-seo-custom-web-title" placeholder="<?php echo trim(sanitize_text_field($web_generated_title)); ?>"><?php echo trim(sanitize_text_field($web_custom_title)); ?></textarea>
			<div id="base-theme-seo-meta-title-info" class="base-theme-seo-meta-info">
			</div>

		  <!-- https://moz.com/learn/seo/meta-description // Between 50-300 char -->
			<label for="base-theme-seo-custom-web-description">Meta Description
		    <span class="base-theme-seo-tooltip">?
		      <span class="base-theme-seo-tooltiptext">The desciption that will appear under the title in a search engine. Recommended between 50-300 characters</span>
		    </span>
		  </label>
		  <textarea rows="4" class="base-theme-seo-textarea" id="base-theme-seo-custom-web-description" name="base-theme-seo-custom-web-description" placeholder="<?php echo trim(sanitize_text_field($web_generated_description)); ?>"><?php echo trim(sanitize_text_field($web_custom_description)); ?></textarea>
			<div id="base-theme-seo-meta-description-info" class="base-theme-seo-meta-info">
			</div>
		  <!-- $('#base-theme-seo-custom-web-description')[0].value.length -->
		</div>
		<div class="tabs_content">
		  <!-- FACEBOOK META -->
			<label for="base-theme-seo-custom-facebook-title">Facebook Title
				<span class="base-theme-seo-tooltip">?
					<span class="base-theme-seo-tooltiptext">The Generated Text is shown as a grayed out placeholder text.</span>
				</span>
			</label>
			<textarea rows="2" class="base-theme-seo-textarea" id="base-theme-seo-custom-facebook-title" name="base-theme-seo-custom-facebook-title" placeholder="<?php
			 echo (isset($web_custom_title) && ! empty ($web_custom_title) ? trim(sanitize_text_field($web_custom_title)) : trim(sanitize_text_field($web_generated_title)));
			 ?>"><?php echo trim(sanitize_text_field($facebook_custom_title)); ?></textarea>

			<label for="base-theme-seo-custom-web-description">Facebook Description
				<span class="base-theme-seo-tooltip">?
					<span class="base-theme-seo-tooltiptext">The Generated Text is shown as a grayed out placeholder text.</span>
				</span>
			</label>
			<textarea rows="4" class="base-theme-seo-textarea" id="base-theme-seo-custom-facebook-description" name="base-theme-seo-custom-facebook-description" placeholder="<?php
			 echo (isset($web_custom_title) && ! empty ($web_custom_description) ? trim(sanitize_text_field($web_custom_description)) : trim(sanitize_text_field($facebook_generated_description)));
			 ?>"><?php echo trim(sanitize_text_field($facebook_custom_description)); ?></textarea>

			<label for="base-theme-seo-custom-twitter-title">Facebook Image Url
				<!-- <span class="base-theme-seo-tooltip">?
					<span class="base-theme-seo-tooltiptext">Tooltip Coming Soon!</span>
				</span> -->
			</label>
			<textarea rows="2" class="base-theme-seo-textarea" id="base-theme-seo-custom-facebook-image" name="base-theme-seo-custom-facebook-image"><?php echo trim(sanitize_text_field($facebook_custom_image)); ?></textarea>
		</div>
		<div class="tabs_content">
		  <!-- TWITTER META -->
			<label for="base-theme-seo-custom-twitter-title">Twitter Title
				<span class="base-theme-seo-tooltip">?
					<span class="base-theme-seo-tooltiptext">The Generated Text is shown as a grayed out placeholder text.</span>
				</span>
			</label>
			<textarea rows="2" class="base-theme-seo-textarea" id="base-theme-seo-custom-twitter-title" name="base-theme-seo-custom-twitter-title" placeholder="<?php
			 echo (isset($web_custom_title) && ! empty ($web_custom_title) ? trim(sanitize_text_field($web_custom_title)) : trim(sanitize_text_field($web_generated_title)));
			 ?>"><?php echo trim(sanitize_text_field($twitter_custom_title)); ?></textarea>

			<label for="base-theme-seo-custom-web-description">Twitter Description
				<span class="base-theme-seo-tooltip">?
					<span class="base-theme-seo-tooltiptext">The Generated Text is shown as a grayed out placeholder text.</span>
				</span>
			</label>
			<textarea rows="4" class="base-theme-seo-textarea" id="base-theme-seo-custom-Twitter-description" name="base-theme-seo-custom-twitter-description" placeholder="<?php
			 echo (isset($web_custom_title) && ! empty ($web_custom_description) ? trim(sanitize_text_field($web_custom_description)) : trim(sanitize_text_field($twitter_generated_description)));
			 ?>"><?php echo trim(sanitize_text_field($twitter_custom_description)); ?></textarea>

			<label for="base-theme-seo-custom-twitter-title">Twitter Image Url
				<!-- <span class="base-theme-seo-tooltip">?
					<span class="base-theme-seo-tooltiptext">Tooltip Coming Soon!</span>
				</span> -->
			</label>
			<textarea rows="2" class="base-theme-seo-textarea" id="base-theme-seo-custom-twitter-image" name="base-theme-seo-custom-twitter-image"><?php echo trim(sanitize_text_field($twitter_custom_image)); ?></textarea>
		</div>
	</div>

<?php
}
