<?php //Base Theme SEO - Create Meta Tags

// exit if file is called directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// add the action
add_action( 'wp_head', 'base_theme_seo_wp_head', 2);
// define the wp_head callback
function base_theme_seo_wp_head( ) {
  $post_id = get_the_ID();
  $final_meta = get_post_meta($post_id, '_base_theme_seo_post_final_meta', true);

  if (isset($final_meta) && ! empty($final_meta)) {
    //if (!$meta_robots) $meta_robots = "index, follow";
    ?>
    <!-- Base Theme SEO Web Meta -->
    <?php //Title is set in another function below filter_document_title_parts ?>
		<?php if (isset($final_meta['desciption']) && ! empty($final_meta['desciption'])) : ?>
	    <meta name="description"          content="<?php echo $final_meta['desciption'];?>" />
		<?php endif; ?>
    <!-- Base Theme SEO Facebook Meta -->
		<?php if (isset($final_meta['facebook-title']) && ! empty($final_meta['facebook-title'])) : ?>
	    <meta property="og:title"         content="<?php echo $final_meta['facebook-title']; ?>" />
		<?php endif; ?>
		<?php if (isset($final_meta['facebook-description']) && ! empty($final_meta['facebook-description'])) : ?>
	    <meta property="og:description"   content="<?php echo $final_meta['facebook-description'];  ?>" />
		<?php endif; ?>
		<?php if (isset($final_meta['facebook-image']) && ! empty($final_meta['facebook-image'])) : ?>
			<?php if ($final_meta['facebook-image'][0] == "/") {
				$final_meta['facebook-image'] = get_home_url() . $final_meta['facebook-image'];
			} ?>
	    <meta property="og:image"         content="<?php echo $final_meta['facebook-image']; ?>" />
		<?php endif; ?>
    <!-- Base Theme SEO Twitter Meta -->
    <meta name="twitter:card"         content="summary_large_image" />
		<?php if (isset($final_meta['twitter-title']) && ! empty($final_meta['twitter-title'])) : ?>
	    <meta name="twitter:title"        content="<?php echo $final_meta['twitter-title']; ?>" />
		<?php endif; ?>
		<?php if (isset($final_meta['twitter-description']) && ! empty($final_meta['twitter-description'])) : ?>
	    <meta name="twitter:description"  content="<?php echo $final_meta['twitter-description'];  ?>" />
		<?php endif; ?>
		<?php if (isset($final_meta['twitter-image']) && ! empty($final_meta['twitter-image'])) : ?>
			<?php if ($final_meta['twitter-image'][0] == "/") {
				$final_meta['twitter-image'] = get_home_url() . $final_meta['twitter-image'];
			} ?>
	    <meta name="twitter:image"        content="<?php echo $final_meta['twitter-image']; ?>" />
		<?php endif; ?>
    <?php
  }


};

// define the document_title_parts callback
function filter_document_title_parts( $title ) {
    $post_id = get_the_ID();
    $post_custom_meta = get_post_meta($post_id, '_base_theme_seo_post_custom_meta', true);
    $web_custom_title = isset($post_custom_meta['title']) ? $post_custom_meta['title'] : '';

    $post_generated_meta = get_post_meta($post_id, '_base_theme_seo_post_generated_meta', true);
    $web_generated_title = isset($post_generated_meta['title']) ? $post_generated_meta['title'] : '';

    if ( ! empty($web_custom_title)) {
      $title['title'] = $web_custom_title;
  	  $title['site']  = '';
    } else if ( ! empty($web_generated_title)) {
      $title['title'] = $web_generated_title;
  	  $title['site']  = '';
    }

    return $title;

};
// add the filter
add_filter( 'document_title_parts', 'filter_document_title_parts', 999, 1 );
