<?php // Base Theme SEO - Settings Page



// exit if file is called directly
if ( ! defined( 'ABSPATH' ) ) {

	exit;

}




// display the plugin settings page
function base_theme_seo_display_settings_page() {

	// check if user is allowed access
	if ( ! current_user_can( 'manage_options' ) ) return;

	?>

	<div class="wrap">
		<h1><?php echo esc_html( get_admin_page_title() ); ?></h1>
		<form action="options.php" method="post">

			<?php

			// output security fields
			settings_fields( 'base_theme_seo_options' );

			// output setting sections
			do_settings_sections( 'base_theme_seo' );
			// submit button
			submit_button();

			/*?>
		    <div style="max-width: 90%; margin: auto;"><pre><?php var_dump($options) ?></pre></div>
		  <?php */

			?>

		</form>
	</div>

	<?php

}
