<?php // MyPlugin - Register Settings



// disable direct file access
if ( ! defined( 'ABSPATH' ) ) {

	exit;

}



// register plugin settings
function base_theme_seo_register_settings() {

	/*

	register_setting(
		string   $option_group,
		string   $option_name,
		callable $sanitize_callback = ''
	);

	*/

	register_setting(
		'base_theme_seo_options',
		'base_theme_seo_options',
		'base_theme_seo_callback_validate_options'
	);

	/*

	add_settings_section(
		string   $id,
		string   $title,
		callable $callback,
		string   $page
	);

	*/

	add_settings_section(
		'base_theme_seo_main_settings',
		'Site Wide Settings',
		'base_theme_seo_callback_main_settings',
		'base_theme_seo'
	);

	/*

	add_settings_field(
    string   $id,
		string   $title,
		callable $callback,
		string   $page,
		string   $section = 'default',
		array    $args = []
	);

	*/


	add_settings_field(
		'post_type_slugs',
		'Post Type Slugs',
		'base_theme_seo_callback_field_textarea_list',
		'base_theme_seo',
		'base_theme_seo_main_settings',
		[ 'id' => 'post_type_slugs', 'label' => 'Post Types Included for SEO. e.g. page, post' ]
	);

	add_settings_field(
		'main_call_order',
		'Main Call Order',
		'base_theme_seo_callback_field_textarea_list',
		'base_theme_seo',
		'base_theme_seo_main_settings',
		[ 'id' => 'main_call_order', 'label' => 'The main call order. Possible choices: the_content, the_field, the_sub_field' ]
	);

	add_settings_field(
		'flexible_content_and_repeater_names',
		'Flexible Content and Repeater Names',
		'base_theme_seo_callback_field_textarea_list',
		'base_theme_seo',
		'base_theme_seo_main_settings',
		[ 'id' => 'flexible_content_and_repeater_names', 'label' => 'The Names of the Flexible Content/Repeaters Included for SEO' ]
	);

	add_settings_field(
		'field_and_subfield_names',
		'Field and Subfield Names',
		'base_theme_seo_callback_field_textarea_list',
		'base_theme_seo',
		'base_theme_seo_main_settings',
		[ 'id' => 'field_and_subfield_names', 'label' => 'The Names of the Fields/Subfields Included for SEO', 'rows' => "24"]
	);


	// add_settings_field(
	// 	'custom_style',
	// 	'Custom Style',
	// 	'base_theme_seo_callback_field_radio',
	// 	'myplugin',
	// 	'base_theme_seo_section_login',
	// 	[ 'id' => 'custom_style', 'label' => 'Custom CSS for the Login screen' ]
	// );

	// add_settings_field(
	// 	'custom_message',
	// 	'Custom Message',
	// 	'base_theme_seo_callback_field_textarea_list',
	// 	'myplugin',
	// 	'base_theme_seo_section_login',
	// 	[ 'id' => 'custom_message', 'label' => 'Custom text and/or markup' ]
	// );
  //
	// add_settings_field(
	// 	'custom_footer',
	// 	'Custom Footer',
	// 	'base_theme_seo_callback_field_text',
	// 	'myplugin',
	// 	'base_theme_seo_section_admin',
	// 	[ 'id' => 'custom_footer', 'label' => 'Custom footer text' ]
	// );

	// add_settings_field(
	// 	'custom_toolbar',
	// 	'Custom Toolbar',
	// 	'base_theme_seo_callback_field_checkbox',
	// 	'myplugin',
	// 	'base_theme_seo_section_admin',
	// 	[ 'id' => 'custom_toolbar', 'label' => 'Remove new post and comment links from the Toolbar' ]
	// );
  //
	// add_settings_field(
	// 	'custom_scheme',
	// 	'Custom Scheme',
	// 	'base_theme_seo_callback_field_select',
	// 	'myplugin',
	// 	'base_theme_seo_section_admin',
	// 	[ 'id' => 'custom_scheme', 'label' => 'Default color scheme for new users' ]
	// );

}
add_action( 'admin_init', 'base_theme_seo_register_settings' );
