<?php
/*
Plugin Name:  SEO Custom Fields
Description:  SEO that is compatible with Custom Fields.
Author:       Wordpress Plugins
Author URI: 		https://www.wordpress.org
Version:      0.0.1
*/

// exit if file is called directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}



// if admin area
if ( is_admin() ) {

	// include plugin dependencies
	require_once plugin_dir_path( __FILE__ ) . 'admin/admin-menu.php';
	require_once plugin_dir_path( __FILE__ ) . 'admin/settings-page.php';
	require_once plugin_dir_path( __FILE__ ) . 'admin/settings-validate.php';
	require_once plugin_dir_path( __FILE__ ) . 'admin/settings-register.php';
	require_once plugin_dir_path( __FILE__ ) . 'admin/settings-callbacks.php';
	require_once plugin_dir_path( __FILE__ ) . 'admin/seo-metadata.php';
	require_once plugin_dir_path( __FILE__ ) . 'admin/posts-meta-box-register.php';
	require_once plugin_dir_path( __FILE__ ) . 'admin/posts-meta-box-display.php';
	require_once plugin_dir_path( __FILE__ ) . 'admin/posts-meta-box-save.php';

	function add_css_to_admin_footer() {
		//admin css
		require_once plugin_dir_path( __FILE__ ) . 'admin/css/admin.css.php';
		require_once plugin_dir_path( __FILE__ ) . 'admin/js/admin-char-limits.js.php';
		require_once plugin_dir_path( __FILE__ ) . 'admin/js/admin-tabs.js.php';
		?> <link href="https://fonts.googleapis.com/css?family=Roboto" rel="stylesheet"> <?php
	}
	add_action('admin_footer', 'add_css_to_admin_footer');
	function enqueue_media_uploader()
	{

	}

	add_action("admin_enqueue_scripts", "enqueue_media_uploader");
}

require_once plugin_dir_path( __FILE__ ) . 'admin/public-meta-tags.php';


/*
Saved for later:
(status)_(post_type) ex: publish_post, publish_post, publish_custom_post_type: Action Hook that will run when a post is created or updated
*/

function base_theme_seo_testing() {
  $options = get_option( 'base_theme_seo_options', base_theme_seo_options_default() );
  echo '<div style="margin-left:160px; padding:25px;"><pre>';
  var_dump($options); echo '<br>';
  if ( isset ($options['post_type_slugs']) && ! empty($options['post_type_slugs'])) {
    //$post_types = explode(PHP_EOL, $options['post_type_slugs']);
    // for ($i = 0; $i < count($post_types); $i++) {
    //   $post_types[$i] = trim($post_types[$i],"\x2C\t\n\r\0\x0B");
    // }
    var_dump($options['post_type_slugs']);
  }
  echo '</pre></div>';
}
//add_action('admin_footer', 'base_theme_seo_testing');

function base_theme_seo_activate() {

	add_option( 'base_theme_seo_options', base_theme_seo_options_default() );

}
register_activation_hook( __FILE__, 'base_theme_seo_activate' );
