<?php
  /*
  Plugin Name: Server Scout
  Plugin URI:
  Description: Simple Admin Dashboard with reporting the IP on which your Wordpress website's PHP is running and returns it.
  Author: Alexander Burton
  Author URI: https://alexburton.com
  Version: 0.0.1
  */

// Register Server Scout Dashboard Widget to WP_Dashboard_Setup
add_action('wp_dashboard_setup', 'server_scout_dashboard_widget');

function server_scout_dashboard_widget() {
  include(plugin_dir_path(__FILE__) . 'constants.php');
  include(plugin_dir_path(__FILE__) . 'dashboard-widget.php');
}

add_action('admin_footer', 'server_scout_admin_footer');

function server_scout_admin_footer() {
  //include(plugin_dir_path(__FILE__) . 'server-scout-js.php');
  echo '<script type="text/javascript">'.
          '(function() {'.
            '"use-strict";'.
            'var dashboard_server_scout = document.querySelector("#dashboard_server_scout");'.
            'var dashboard_column = document.querySelector("#postbox-container-1 .meta-box-sortables");'.
            'dashboard_column.prepend(dashboard_server_scout);'.
            'dashboard_server_scout.classList.remove("hidden")'.
          '})();'.
        '</script>';
}




?>
