jQuery(document).ready(function($) {

  $('.ajax-feeder-button').on('click', function() {
      var this_button = $(this);
      var data_feed = $(this).attr('data-feed');
      var data_args = JSON.parse($(this).attr('data-args'));
      var data_batch = $(this).attr('data-batch');
      var data_temp = $(this).attr('data-temp');
      console.log({data_feed: data_feed, data_args: data_args});

      var ajax_request = {
        url: wp_ajax_feeder,
        type: 'POST',
        //dataType: 'json',
        data: {
          action: 'the_ajax_feeder',
          args: data_args,
          batch: data_batch,
          template: data_temp
        }
      };
      console.log(ajax_request);

      function ajax_batcher(data_feed) {
          var this_button = $('button[data-feed="'+data_feed+'"]');
          var current_batch = parseInt(this_button.attr('data-batch'));
          if(this_button[0].hasAttribute('data-batch-inc') === false) {
            this_button.attr('data-batch-inc', current_batch);
          }
          var batch_inc = parseInt(this_button.attr('data-batch-inc'));
          var new_batch = current_batch + batch_inc;
          var data_max = parseInt(this_button.attr('data-max'));

          if(new_batch < data_max) {
            this_button.attr('data-batch', current_batch + batch_inc);
          } else {
            this_button.remove();
          }
      }

      if(typeof ajax_request.data.args === 'object' && ajax_request.data.args !== null) {
          // Init $.ajax()
          $.ajax(ajax_request)
          .success(function(data, data2, data3) {
            console.log({success: {data: data, data2: data2, data3: data3}});

            ajax_batcher(data_feed);

            $(data_feed).append(data);
          })
          .fail(function(data, data2, data3) {
            console.log({fail: data, data2: data2, data3: data3});
          });
      } else {
        console.log(ajax_request);
        console.log('something is wrong with ajax_request.data.args');
      }

  });

});
