<?php

function post_types_array($post_types) {
    if(count($post_types) > 0) {
        $post_types_arr = array();
        for($p = 0; $p < count($post_types); $p++) {
            array_push($post_types_arr, $post_types[$p]['post_type']);
        }
        return $post_types_arr;
    } else {
        return false;
    }
}

function meta_query_array($meta_query) {
    if(count($meta_query) > 0) {
        $meta_query_arr = array();
        for($m = 0; $m < count($meta_query); $m++) {
            array_push($meta_query_arr, array(
                'key'     => $meta_query[$m]['key'] ? $meta_query[$m]['key'] : '',
                'value'     => $meta_query[$m]['value'] ? $meta_query[$m]['value'] : '',
                'compare'     => $meta_query[$m]['compare'] ? $meta_query[$m]['compare'] : 'IN',
            ));
        }
        return $meta_query_arr;
    } else {
        return false;
    }
}

$post_block = array(
    'template_part'     => get_sub_field('template_part') ? get_sub_field('template_part') : false,
    'post_types'        => get_sub_field('post_types') ? post_types_array(get_sub_field('post_types')) : false,
    'numberposts'       => get_sub_field('numberposts') ? (int)get_sub_field('numberposts') : false,
    'posts_per_page'    => get_sub_field('posts_per_page') ? (int)get_sub_field('posts_per_page') : false,
    'pagination'        => get_sub_field('pagination') ? get_sub_field('pagination') : false,
    'pagination_var'    => get_sub_field('pagination_var') ? get_sub_field('pagination_var') : false,
    'orderby'           => get_sub_field('orderby') ? get_sub_field('orderby') : false,
    'order'             => get_sub_field('order') ? get_sub_field('order') : false,
    'meta_query'        => get_sub_field('meta_query') ? meta_query_array(get_sub_field('meta_query')) : false
);

$block_scripts = block_scripts();

$options = flex_options();

// $open_wrap = flex_open_wrap($options);

// $close_div = '</div>';

$query_keys = array('post_type', 'numberposts', 'posts_per_page', 'orderby', 'order', 'meta_query');

$query_args = array();

if($post_block['post_types']) {$query_args['post_type'] = $post_block['post_types'];}
if($post_block['numberposts']) {$query_args['numberposts'] = $post_block['numberposts'];}
if($post_block['posts_per_page']) {$query_args['posts_per_page'] = $post_block['posts_per_page'];}
if($post_block['order']) {$query_args['order'] = $post_block['order'];}
if($post_block['meta_query']) {$query_args['meta_query'] = $post_block['meta_query'];}


$flex_query = new WP_Query($query_args);

// console_log(array(
//     'flex_query'     => $flex_query,
//     'query_args'     => $query_args,
//     'options'        => $options,
//     'post_block'     => $post_block,
//     'get_fields'     => get_fields()
// ));

echo $block_scripts['block_header'];
// echo $open_wrap;

if($flex_query->have_posts()): while($flex_query->have_posts()): $flex_query->the_post();
    if($post_block['template_part']) {get_template_part($post_block['template_part']);} else {echo '<h2>No Template Set....</h2>';}
endwhile; endif; wp_reset_query();

// echo $close_div;
echo $block_scripts['block_footer'];
