// Begin Base Theme JavaScript

jQuery(document).ready(function($) {
// Cookie JSON Functional Object
let CookieJSON = {
    all: function CookieJSON() {
        let cookie_split = document.cookie.split('; ');
        let cookie_obj = {};
        if(cookie_split.length > 0) {
          cookie_split.forEach(function(el) {
            let sub_el = el.split('=');
            cookie_obj[sub_el[0]] = sub_el[1];
          });
        }
        return cookie_obj;
    },
    get: function(name) {
      var v = document.cookie.match('(^|;) ?' + name + '=([^;]*)(;|$)');
      return v ? v[2] : null;
    },
    set: function(name, value, days) {
      var d = new Date;
      d.setTime(d.getTime() + 24*60*60*1000*days);
      document.cookie = name + "=" + value + ";path=/;expires=" + d.toGMTString();
    }
};

//---- Data Counter JS ----//
var data_counter = $('.counter').each(function() {
  var $this = $(this),
      countTo = $this.attr('data-count');

  $({ countNum: $this.text()}).animate(
    {countNum: countTo},
    {
      duration: 2000,
      easing:'linear',
      step: function() {
        $this.text(Math.floor(this.countNum));
      },
      complete: function() {
        $this.text(this.countNum);
        //alert('finished');
      }
  })});

});
