jQuery(document).ready(function($) {

    // Full Banner JS
    function FullBannerJS(config) {

        let banner_images = config.banner_images;

        let timeInterval = config.time_interval;

        let banner_selector = config.banner_slideshow;

        let banner_slideshow = $('#'+config.banner_slideshow);

        let animation_speed = config.animation_speed;

        banner_slideshow.css({
          "left": "0px", "top": "0px", "overflow": "hidden", "margin": "0px", "padding": "0px",
          "height": "1280px", "width": "1920px", "z-index": "-999999", "position": "fixed",
        });

        let banner_images_length = banner_images.length;

        var intervalDuration = parseInt((banner_images_length) * timeInterval);

        // Create Banner Overlay and Insert it Before the Banner Slideshow
        // if(config.banner_overlay === true) {
            var banner_overlay = '<div id="overlay" style="position:fixed;top:0;left:0;width:100%;height:100%;z-index:-1;opacity:0.5;background-color:#000;"></div>';
            $(banner_overlay).insertBefore(banner_slideshow);
        // }

        // Execute a Single Interval of the Banner Slideshow Functionality
        function banner_interval(b, banner_images, banner_slideshow, banner_selector, banner_images_length, animation_speed) {
            setTimeout(function() {
              var banner_image = '<img src="'+banner_images[b]+'" class="'+banner_selector+'--slide-'+(b+1)+'" alt="banner-image-'+(b+1)+'" style="position: absolute; opacity: 0; margin: 0px; padding: 0px; border: none; width: 1920px; height: 1280px; max-height: auto; max-width: none; z-index: -999999; left: 0px; top: -256.5px;" />';
              var current_banner = $('#'+banner_selector+' img:nth-child(1)');

              if(b === 0) {
                var prev_slide = banner_images_length;
              } else {
                var prev_slide = b;
              }
              //console.log({current_banner: current_banner});
              if(current_banner.length === 0) {
                  //console.log('no current banner');
                  banner_slideshow.append(banner_image);
                  $('.'+banner_selector+'--slide-'+(b+1)).animate({opacity: 1}, animation_speed);
              } else {
                  //console.log('current banner exists');

                  // $(banner_selector+'--slide-'+(b+1)).fadeOut(2000, function() {
                  //     banner_slideshow.append(banner_image).hide().fadeIn(2000);
                  //     $(this).remove();
                  // });

                  banner_slideshow.append(banner_image);

                  $('.'+banner_selector+'--slide-'+(b+1)).animate({opacity: 1}, animation_speed);
                  $('.'+banner_selector+'--slide-'+prev_slide).animate({opacity: 0}, {duration: animation_speed, complete: function(){$(this).remove();}});



                  $(banner_selector+'--slide-'+(b+1)).next();

                  //banner_slideshow.append(banner_image).hide().fadeIn(2000);
                    //banner_slideshow.append(banner_image).hide()
                    //$(this).next().fadeIn();

                    //$(this).remove();
                  //});
              }

              //console.log({b_timeInterval: b * timeInterval});
            }, (b) * timeInterval);
        } // END: banner_interval()

        // Run the Banner Slideshow Function for each Image in the banner_images array
        function run_banner_slideshow(banner_selector, banner_slideshow, banner_images, banner_images_length, animation_speed) {
            for(b = 0; b < banner_images_length; b++) {
                //var current_banner = $('#'+banner_selector+' img:nth-child(1)');
                //console.log({current_banner: current_banner});
                banner_interval(b, banner_images, banner_slideshow, banner_selector, banner_images_length, animation_speed);
            }
        }


        if(banner_images_length > 0) {
            // Run the First Time
            run_banner_slideshow(banner_selector, banner_slideshow, banner_images, banner_images_length, animation_speed);
            // Then Set the Interval: This ensures the Banner Slideshow runs for eternity
            setInterval(function() {
               run_banner_slideshow(banner_selector, banner_slideshow, banner_images, banner_images_length, animation_speed);
            }, intervalDuration);
        }
    } // END: FullBannerJS()

    // Add a DIV tag with the ID you wish to target for FullBannerJS to build the banner
    //<div id="banner-slideshow"></div>


    // FullBannerJS({
    //     banner_slideshow: 'banner-slideshow',
    //     time_interval: 5000,
    //     animation_speed: 1000,
    //     // banner_overlay: true,
    //     banner_images: <?php echo $banner_images; ?>,
    //         // 'https://via.placeholder.com/1920',
    //         // 'https://via.placeholder.com/1921',
    //         // 'https://via.placeholder.com/1922',
    //         // 'https://via.placeholder.com/1923',
    //         // 'https://via.placeholder.com/1924'
    //
    // });

    // EXAMPLE PHP To Set the Image Gallery Array using an ACF Repeater's nest Image Sub Field's URL
    // function ACF_Repeater_Array($acf_repeater_field, $image_sub_field) {
    //     $acf_repeater = get_field($acf_repeater_field);
    //     $gallery_array = array();
    //     while(has_sub_field($acf_repeater_field)) {
    //         array_push($gallery_array, get_sub_field($image_sub_field));
    //     }
    //     $banner_array = '["' . implode('", "', $gallery_array) . '"]';
    //     return $banner_array;
    // }
    //
    // $acf_repeater_array = ACF_Repeater_Array('home_page_gallery', 'image');

});
