<style>
@import url('https://fonts.googleapis.com/css2?family=Marvel:ital,wght@0,400;0,700;1,400;1,700&family=Oswald:wght@200;300;400;469;500;600;700&display=swap');

:root {
  --abx-marvel: font-family: 'Marvel', sans-serif;
  --abx-oswald: font-family: 'Oswald', sans-serif;
  --abx-white: #FFFFFF;
  --abx-black: #000000;
  --abx-white: #fff;
  --abx-grey: #f7f7f7;
  --abx-dark: #333;
  --abx-black: #000;
  --abx-red: #e74c3c;
  --abx-orange: #e67e22;
  --abx-yellow: #f1c40f;
  --abx-green: #2ecc71;
  --abx-blue: #3498db;
  --abx-purple: #9b59b6;
  --gg-french-pass: #b0fcfc;
  --gg-japanese-laurel: #278c00;
  --gg-golden-bell: #db850e;
  --gg-light: #f2f7f7; /* Aqua Haze */
  --gg-calypso: #31708f;
}

/* Fonts */
h1,h2,h3,h4,h5,h6, #main-menu li a,
.abx-oswald {font-family: var(--abx-oswald);}
div,ul,li,a,p,button,select,input,textarea,
.abx-marvel {font-family: var(--abx-marvel);}
h1 span {display:block;}
a, button {cursor:pointer;}
a:hover {text-decoration:none !important;}
/* h1 .big-title, h1 .little-title {} */
.anim-hidden {visibility: hidden;}
.lh-2 {line-height:2;}
input, select, textarea {outline: none !important; border-color:transparent !important; box-shadow:none !important;}

/* MAIN */
.row{margin-left:0 !important; margin-right:0 !important;}
.full-banner-bg {background-size: cover !important; background-repeat: no-repeat !important; background-position: center !important;}
.parallax {background-attachment: fixed;}
.anti-wrapper {max-width:100% !important; width: 100% !important; padding:0 !important; margin:0 !important;}
.friendly-order {display: inline;}
*:focus {outline: none !important;}

.abx-white {background-color: var(--abx-white);}
.abx-black {background-color: var(--abx-black);}
.gg-french-pass {background-color: var(--gg-french-pass);}
.gg-japanese-laurel {background-color: var(--gg-japanese-laurel);}
.gg-golden-bell {background-color: var(--gg-golden-bell);}
.gg-light {background-color: var(--gg-light);}
.gg-calypso {background-color: var(--gg-calypso);}
/* .gg- {background-color: var(--gg-);} */

.abx-white-text {color: var(--abx-white);}
.abx-black-text {color: var(--abx-black);}
.gg-french-pass-text {color: var(--gg-french-pass);}
.gg-japanese-laurel-text {color: var(--gg-japanese-laurel);}
.gg-golden-bell-text {color: var(--gg-golden-bell);}
.gg-light-text {color: var(--gg-light);}
.gg-calypso-text {color: var(--gg-calypso);}
/* .gg- {color: var(--gg-);} */

.abx-white-border {border-color: var(--abx-white);}
.abx-black-border {border-color: var(--abx-black);}
.gg-french-pass-border {border-color: var(--gg-french-pass);}
.gg-japanese-laurel-border {border-color: var(--gg-japanese-laurel);}
.gg-golden-bell-border {border-color: var(--gg-golden-bell);}
.gg-light-border {border-color: var(--gg-light);}
.gg-calypso-border {border-color: var(--gg-calypso);}
/* .gg- {border-color: var(--gg-);} */

/* Centerize */
.centerize {display:block; margin:0 auto;}
.ctz-xs {max-width: 400px;}
.ctz-sm {max-width: 600px;}
.ctz-md {max-width: 800px;}
.ctz-lg {max-width: 1000px;}
.ctz-xlg {max-width: 1100px;}
.ctz-xl {max-width: 1200px;}
.ctz-xxl {max-width: 1440px;}

.fw-900 {font-weight:900;}
.fw-800 {font-weight:800;}
.fw-700 {font-weight:700;}
.fw-600 {font-weight:600;}
.fw-500 {font-weight:500;}
.fw-400 {font-weight:400;}

/* Animation Delays */
.ad-300 {animation-delay: 0.3s;}
.ad-500 {animation-delay: 0.5s;}
.ad-750 {animation-delay: 0.75s;}
.ad-1000 {animation-delay: 1s;}
.ad-1250 {animation-delay: 1.25s;}
.ad-1500 {animation-delay: 1.5s;}
.ad-2000 {animation-delay: 2s;}
.ad-2500 {animation-delay: 2.5s;}
.ad-3000 {animation-delay: 3s;}

.gangagen-button, input[type="submit"] {
  padding:1rem 2rem !important; background-color: var(--gg-light) !important; color: var(--gg-japanese-laurel) !important;
  font-weight:700 !important; border:solid 2px var(--gg-japanese-laurel) !important; transition:all 0.2s linear !important;
}

.gangagen-button-clear {
  padding:1rem 2rem; background-color: transparent; color: var(--abx-white);
  font-weight:700; border:solid 2px var(--abx-white); transition:all 0.2s linear;
}

.gangagen-button-calypso {
  padding:1rem 2rem; background-color: var(--gg-light); color: var(--gg-calypso);
  font-weight:700; border:solid 2px var(--gg-calypso); transition:all 0.2s linear;
}

.gangagen-button:hover, input[type="submit"]:hover {
  background-color: var(--gg-japanese-laurel) !important;
  color: var(--gg-light) !important;
}

.gangagen-button-calypso:hover {
  background-color: var(--gg-calypso);
  color: var(--gg-light); border-color: var(--gg-calypso);
}

.gg-check {
	padding: 0.5rem;
  	background: var(--gg-calypso);
  	border-radius: 50%;
  	color: var(--gg-light);
  	font-size: 1.4rem;
}

.back-to-top {
    float: right;
    position: fixed;
    font-size: 1rem !important;
    bottom: 0;
    right: 0;
    background: rgba(0, 0, 0, 0.4);
    width: 125px;
    height: 100px;
    text-align: center;
    display: table;
}

/* Navigation */

/* TEMPLATE: Navigation */
#main-menu > li > a.nav-link,
/* #main-menu .dropdown-menu > li > a {color: var(--vtj-green); transition:all 0.2s linear;}
#main-menu > li > a.nav-link:hover {background: var(--vtj-green); color: var(--vtj-white);} */
#main-menu .dropdown-menu > li > a {color: var(--gg-japanese-laurel); transition:all 0.2s linear; text-transform: uppercase;}
#main-menu > li > a.nav-link:hover {color: var(--abx-white); background-color: var(--gg-japanese-laurel);}
@media screen and (max-width:767px) {
  #main-menu li {text-align: center; padding: 0.5rem;}
  #main-menu > li > a.nav-link {padding: 1rem; text-align: center;}
}
@media screen and (min-width:768px) {
  #main-menu > li > a.nav-link {padding: 2rem 0.5rem;}
}

@media screen and (max-width:1199px) {
  #main-menu {width: 70%; margin: 0 auto; text-align: center;}
}

@media screen and (min-width:1200px) {
  #menu-item-314 ul.dropdown-menu {margin-left:-86%;}
}

#abx-footer-menu {list-style:none;}
#abx-footer-menu > li {width: auto; max-width: 120px; display: inline-block; height:88px;}
#abx-footer-menu > li > a.nav-link {color:var(--gg-japanese-laurel); height:88px;}

#main-menu .dropdown-menu {border: none; text-align: center;}
#main-menu .dropdown-menu > li > a {padding:1rem; color: var(--gg-japanese-laurel);}

/* #main-menu .dropdown-item.active, */
/* #main-menu .dropdown-item:active  {background-color:var(--vtj-green) !important; color: var(--vtj-white) !important;} */
#main-menu .dropdown-item {text-transform: uppercase;}
#main-menu .dropdown-item.active,
#main-menu .dropdown-item:hover,
#main-menu .dropdown-item:active  {background-color: var(--gg-japanese-laurel); color: var(--gg-light) !important;}

#main-menu li.menu-item ul.dropdown-menu {margin-top: -5px;}

#menu-item-336 a, #menu-item-441 a {
    background-color: var(--gg-light);
}

/* Home Page */

/* ~~~ Full Banner Video ~~~ */
#full-video-wrap {position: relative; height: 620px; overflow:hidden;}
#full-video {
  position: absolute; top: 50%; left: 50%; min-width: 100%; min-height: 100%; width: auto; height: 620px; z-index: -10;
  background-color: black; -webkit-transform: translateX(-50%) translateY(-50%); transform: translateX(-50%) translateY(-50%);
}

#full-video-overlay {
  position: absolute; z-index: -2; width: 100%; top: 0; right: 0; bottom: 0;
  left: 0; background: linear-gradient(rgba(0,0,0,0.3),rgba(0,0,0,0.3));
}

#full-video-overlay h1,
#abx-header-banner h1 {text-shadow: 0px 0px 12px #000;}

#full-video iframe {width: 300%; height: 1080px; position: absolute; top: -15%; left: -100%;}

#gangagen_home_swiper .swiper-slide {
  padding: 34% 0 0 0;
  background-size: cover !important;
  background-repeat: no-repeat !important;
}
.gangagen-overlay {
  padding: 2rem 1rem;
  color: #fff;
  background: rgba(0,0,0,0.5);
  height: 150px;
}
.gangagen-overlay h1, .gangagen-overlay h2 {color: #ffffff; font-weight:900;}

/* Management */
.circle-photo {width: 160px; height: 160px; overflow: hidden; border-radius: 50%; margin:0 auto;}
.abx-management {cursor:pointer;}
.abx-management:hover {background: var(--abx-blue); color: var(--abx-white);}
.abx-management:hover * {color:var(--abx-white) !important;}
.sidelines {display: block; font-family: var(--abx-blue) !important; text-transform: uppercase; font-weight: 900; color: var(--abx-color);}
.sidelines::before, .sidelines::after {
   content: "";
   display: inline-block;
   width: 50px;
   padding: 2px;
   background: var(--abx-blue);
   margin-bottom: 3px;
}
.abx-management:hover .sidelines::before, .abx-management:hover .sidelines::after {background: var(--abx-white) !important;}
.sidelines::before {margin-right:7px;}
.sidelines::after {margin-left:7px;}

/* Contact Form */
li.gfield input, li.gfield textarea, li.gfield select {width: 100% !important; display: block; margin: 0 auto;}
li.gfield {display: inline-block;}

/* GangaGen Card */
.gangagen-card {padding:1.2rem; box-shadow:0 0 8px #e0e0e0; background-color:var(--abx-white); margin-bottom:2rem; border-left: solid 8px var(--gg-japanese-laurel); transition: all 0.2s linear; cursor:pointer;}
.gangagen-card-title {color: var(--gg-calypso);}
.gangagen-card-content {color: var(--gg-golden-bell);}
.gangagen-card:hover {background-color: var(--gg-golden-bell); border-left: solid 24px var(--gg-japanese-laurel); box-shadow:0 0 36px #b7b7b7 !important;}
.gangagen-card:hover .gangagen-card-title,
.gangagen-card:hover .gangagen-card-content {color: var(--abx-white);}
.gangagen-card:hover h2,
.gangagen-card:hover h3,
.gangagen-card:hover h4,
.gangagen-card:hover em,
.gangagen-card:hover a,
.gangagen-card:hover p {color:var(--gg-light) !important;}
@media screen and (max-width:767px) {
  .gangagen-card-body .col-md-9 {text-align:center;}
  .loop-event {width:350px; margin:0 auto;}
}

@media screen and (min-width:992px) {#abx-pillars h2 {font-size:1.5vw;} }
@media screen and (min-width:768px) and (max-width:991px) {#abx-pillars h2 {font-size:2.5vw;} }
@media screen and (max-width:767px) {#abx-pillars h2 {font-size:3.5vw;} }
</style>
