<!-- ******************* The Navbar Area ******************* -->
<div id="wrapper-navbar" itemscope itemtype="http://schema.org/WebSite">

  <!-- <a class="skip-link sr-only sr-only-focusable" href="#content"><?php // esc_html_e( 'Skip to content', 'understrap' ); ?></a> -->
  <?php
    $main_logo = wp_get_attachment_image_src(get_theme_mod('custom_logo'), 'full')[0];
    $custom_page_logo = get_field('custom_page_logo', get_the_ID());
    $base_logo = get_field('base_logo', 'option');
    $dynamic_logo = $custom_page_logo ? $custom_page_logo : ($main_logo ? $main_logo : ($base_logo ? $base_logo : false));
  ?>

  <nav class="navbar navbar-expand-xl gg-japanese-laurel-text abx-white">

    <div class="container centerize" style="max-width:1220px;">


      <a href="/" style="color:#fff;">
        <?php if($dynamic_logo): ?>
          <img src="<?php echo $dynamic_logo; ?>" alt="<?php echo get_the_title(); ?>" style="height:75px; display:block;" />
        <?php else: ?>
          <span class="h2"><?php echo wp_title(); ?></span>
        <?php endif; ?>
      </a>

      <button class="navbar-toggler gg-japanese-laurel" type="button" data-toggle="collapse" data-target="#navbarNavDropdown" aria-controls="navbarNavDropdown" aria-expanded="false" aria-label="<?php esc_attr_e( 'Toggle navigation', 'understrap' ); ?>">
        <i class="fa fa-bars abx-white-text"></i>
      </button>

      <!-- The WordPress Menu goes here -->
      <?php wp_nav_menu(
        array(
          'theme_location'  => 'primary',
          'container_class' => 'collapse navbar-collapse',
          'container_id'    => 'navbarNavDropdown',
          'menu_class'      => 'navbar-nav ml-auto',
          'fallback_cb'     => '',
          'menu_id'         => 'main-menu',
          'depth'           => 2,
          'walker'          => new Understrap_WP_Bootstrap_Navwalker(),
        )
      ); ?>

    </div><!-- .container -->

  </nav><!-- .site-navigation -->

</div><!-- #wrapper-navbar end -->
